# Simple Emojis Modpack
Simple Emojis adds an inventory menu, from which players can display various
emojis. The modpack also provides an API for easy emoji registration.

Default pack provides 20 emojis in PHP board style made by Tempodrone.

This modpack is an independent implementation of idea 
from [emoji](https://github.com/bosapara/emoji) mod by Bosapara.

![Screenshot](screenshot.png)

## Requirements
### Mandatory

- [Luanti](https://www.luanti.org/downloads);
- [minetest_game](https://github.com/luanti-org/minetest_game).

## How to use
Open your inventory ("i") and navigate to a new tab called "Emojis". Simply
pressing any of the emojis will make them appear above player's character.
Emojis will dissapear after a defined amount of time.

## Settingtypes
`simple_emojis` provides configuration options, accessible either in Luanti
client settings or by putting configuration options and their values
directly into your `minetest.conf`.

Full list of options, along with their documentation and possible values
is available in this file: [settingtypes.txt](simple_emojis/settingtypes.txt), 
located in `simple_emojis/settingtypes.txt` in this repository.

## Integration with other mods (API)
`simple_emojis` provides this public function:

```
--------------------------------------------------------------------------------

simple_emojis.register_emoji(name, image, sound)

- name - unique id of the emoji;
- image - name of the image file to use;
- sound - name of the sound file to play.

--------------------------------------------------------------------------------
```

## License And Credits
All code in this repository is made by Fruitsnack, unless stated 
or implied otherwise in:

- "License And Credits" section in README (this section);
- Individual file headers;
- Git commit history;
- Merge requests and other means of contribution (i.e. by mailing patches).

Code and text files that are made by Fruitsnack are licensed
under AGPL-3.0-only.  
Full text of the license is available in this file: 
[LICENSE-AGPL-3.0-ONLY](LICENSE-AGPL-3.0-ONLY) in this repository, or, 
alternatively, [here](https://www.gnu.org/licenses/agpl-3.0.en.html).

All files (emojis) located in `simple_emojis_default/textures` were made by 
Tempodrone and licensed under GPL-3.0.
Full text of the license is available in this file: 
[LICENSE-GPL-3.0](LICENSE-GPL-3.0) in this repository, or, 
alternatively, [here](https://www.gnu.org/licenses/gpl-3.0.en.html).

`simple_emojis_default/simple_emojis_default_sound.ogg` (original name
`doorbell_notification.wav) was made by thebuilder15 and released on 
freesound.org under CC0.
Full text of the license is available in this file: 
[LICENSE-CC0](LICENSE-CC0) in this repository, or, 
alternatively, [here](https://creativecommons.org/publicdomain/zero/1.0/).

Assets and media files that are made by Fruitsnack are licensed
under CC-BY-SA-4.0.  
Full text of the license is available in this file: 
[LICENSE-CC-BY-SA-4.0](LICENSE-CC-BY-SA-4.0) in this repository, or, 
alternatively, [here](https://creativecommons.org/licenses/by-sa/4.0/).

`screenshot.png` was made by Fruitsnack using 
[Pixelify-Sans](https://github.com/eifetx/Pixelify-Sans) font by 
Stefie Justprince, licensed under OFL-1.1.  
Full text of the license is available in this file: 
[LICENSE-OFL-1.1](LICENSE-OFL-1.1) in this repository, or, alternatively, 
[here](https://openfontlicense.org/open-font-license-official-text/).

```
    Simple Emojis - Modpack for Luanti and minetest_game that adds an
    emoji menu
    Copyright (C) 2025 Fruitsnack

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License version 3 as
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
```

Link to the original source code repository: 
https://codeberg.org/fruitsnack/simple_emojis
