local mod_name = core.get_current_modname()

-------------------------------------------------------------------------------
--Common
-------------------------------------------------------------------------------

local dusts = {
    "Februm",
    "Egerum",
    "Arcanite",
    "Meteorite",
}

local runes = {
    "Harm",
    "Scatter",
    "Projectile",
    "Improve",
    "Focus",
    "Beam",
    "Alter",
    "Self",
}

local gems = {
    "Storm",
    "Light",
    "Ice",
    "Fire",
    "Energy",
    "Earth",
    "Space",
}

local crystals = {
    "Lesser",
    "Greater",
    "Grand",
}

for _,v in pairs(dusts) do
    local k = string.lower(v)
    core.register_craftitem(mod_name .. ":" .. k .. "_dust", {
        description = v .. " Dust",
        inventory_image = mod_name .. "_" .. k .. "_dust.png"
    })
end

for _,v in pairs(runes) do
    local k = string.lower(v)
    core.register_craftitem(mod_name .. ":" .. k .. "_rune", {
        description = v .. " Rune",
        inventory_image = mod_name .. "_" .. k .. "_rune.png"
    })
end

for _,v in pairs(gems) do
    local k = string.lower(v)
    core.register_craftitem(mod_name .. ":" .. k .. "_gem", {
        description = v .. " Gem",
        inventory_image = mod_name .. "_" .. k .. "_gem.png"
    })
end

for _,v in pairs(crystals) do
    local k = string.lower(v)
    core.register_craftitem(mod_name .. ":" .. k .. "_power_crystal", {
        description = v .. " Power Crystal",
        inventory_image = mod_name .. "_" .. k .. "_power_crystal.png"
    })
end

-------------------------------------------------------------------------------
--Unique
-------------------------------------------------------------------------------

core.register_craftitem(mod_name .. ":amber", {
    description = "Amber",
    inventory_image = mod_name .. "_amber.png"
})

core.register_craftitem(mod_name .. ":egerum_crystal", {
    description = "Egerum Crystal",
    inventory_image = mod_name .. "_egerum.png"
})

core.register_craftitem(mod_name .. ":februm_crystal", {
    description = "Februm Crystal",
    inventory_image = mod_name .. "_februm.png"
})

core.register_craftitem(mod_name .. ":meteorite", {
    description = "Meteorite",
    inventory_image = mod_name .. "_meteorite.png"
})

core.register_craftitem(mod_name .. ":meteorite_ingot", {
    description = "Meteorite Ingot",
    inventory_image = mod_name .. "_meteorite_ingot.png"
})

core.register_craftitem(mod_name .. ":arcanite_ingot", {
    description = "Arcanite Ingot",
    inventory_image = mod_name .. "_arcanite_ingot.png"
})

core.register_craftitem(mod_name .. ":amber_brick", {
    description = "Amber Brick",
    inventory_image = mod_name .. "_amber_brick.png"
})

core.register_craftitem(mod_name .. ":rune_base", {
    description = "Rune Base",
    inventory_image = mod_name .. "_rune_base.png"
})

core.register_craftitem(mod_name .. ":gem_base", {
    description = "Gem Base",
    inventory_image = mod_name .. "_gem_base.png"
})

core.register_craftitem(mod_name .. ":magic_storage_gem", {
    description = "Magic Storage Gem",
    inventory_image = mod_name .. "_magic_storage_gem.png"
})
