local mod_name = core.get_current_modname()

-------------------------------------------------------------------------------
--Amber
-------------------------------------------------------------------------------

core.register_tool(mod_name .. ":sword_amber", {
    description = "Amber Sword",
    inventory_image = mod_name .. "_amber_sword.png",
    tool_capabilities = {
        full_punch_interval = 0.7,
        max_drop_level = 1,
        groupcaps = {
            snappy = {
            times = { [1] = 1.90, [2] = 0.90, [3] = 0.30 },
            uses = 40,
            maxlevel = 3,
            },
        },
        damage_groups = { fleshy = 8 },
    },
    sound = { breaks = "default_tool_breaks" },
    groups = { sword = 1 }
})

core.register_tool(mod_name .. ":axe_amber", {
    description = "Amber Axe",
    inventory_image = mod_name .. "_amber_axe.png",
    tool_capabilities = {
        full_punch_interval = 0.9,
        max_drop_level = 1,
        groupcaps = {
            choppy = {
            times = { [1] = 2.10, [2] = 0.90, [3] = 0.50 },
            uses = 30,
            maxlevel = 3,
            },
        },
        damage_groups = { fleshy = 7 },
    },
    sound = { breaks = "default_tool_breaks" },
    groups = { axe = 1 }
})

core.register_tool(mod_name .. ":shovel_amber", {
    description = "Amber Shovel",
    inventory_image = mod_name .. "_amber_shovel.png",
    wield_image = mod_name .. "_amber_shovel.png^[transformR90",
    tool_capabilities = {
        full_punch_interval = 1.0,
        max_drop_level = 1,
        groupcaps = {
            crumbly = {
            times={ [1] = 1.10, [2] = 0.50, [3] = 0.30 },
            uses = 30,
            maxlevel = 3,
            },
        },
        damage_groups = { fleshy = 4 },
    },
    sound = { breaks = "default_tool_breaks" },
    groups = { shovel = 1 }
})

core.register_tool(mod_name .. ":pick_amber", {
    description = "Amber Pickaxe",
    inventory_image = mod_name .. "_amber_pickaxe.png",
    tool_capabilities = {
        full_punch_interval = 0.9,
        max_drop_level = 3,
        groupcaps = {
            cracky = {
            times={ [1] = 2.0, [2] = 1.0, [3] = 0.50 },
            uses = 30,
            maxlevel = 3,
            },
        },
        damage_groups = { fleshy = 5 },
    },
    sound = { breaks = "default_tool_breaks" },
    groups = { pickaxe = 1 }
})

-------------------------------------------------------------------------------
--Arcanite
-------------------------------------------------------------------------------

core.register_tool(mod_name .. ":sword_arcanite", {
    description = "Arcanite Sword",
    inventory_image = mod_name .. "_arcanite_sword.png",
    tool_capabilities = {
        full_punch_interval = 0.7,
        max_drop_level = 1,
        groupcaps = {
            snappy = {
            times = { [1] = 1.90, [2] = 0.90, [3] = 0.30 },
            uses = 40,
            maxlevel = 3,
            },
        },
        damage_groups = { fleshy = 8 },
    },
    sound = { breaks = "default_tool_breaks" },
    groups = { sword = 1 }
})

core.register_tool(mod_name .. ":axe_arcanite", {
    description = "Arcanite Axe",
    inventory_image = mod_name .. "_arcanite_axe.png",
    tool_capabilities = {
        full_punch_interval = 0.9,
        max_drop_level = 1,
        groupcaps = {
            choppy = {
            times = { [1] = 2.10, [2] = 0.90, [3] = 0.50 },
            uses = 30,
            maxlevel = 3,
            },
        },
        damage_groups = { fleshy = 7 },
    },
    sound = { breaks = "default_tool_breaks" },
    groups = { axe = 1 }
})

core.register_tool(mod_name .. ":shovel_arcanite", {
    description = "Arcanite Shovel",
    inventory_image = mod_name .. "_arcanite_shovel.png",
    wield_image = mod_name .. "_arcanite_shovel.png^[transformR90",
    tool_capabilities = {
        full_punch_interval = 1.0,
        max_drop_level = 1,
        groupcaps = {
            crumbly = {
            times={ [1] = 1.10, [2] = 0.50, [3] = 0.30 },
            uses = 30,
            maxlevel = 3,
            },
        },
        damage_groups = { fleshy = 4 },
    },
    sound = { breaks = "default_tool_breaks" },
    groups = { shovel = 1 }
})

core.register_tool(mod_name .. ":pick_arcanite", {
    description = "Arcanite Pickaxe",
    inventory_image = mod_name .. "_arcanite_pickaxe.png",
    tool_capabilities = {
        full_punch_interval = 0.9,
        max_drop_level = 3,
        groupcaps = {
            cracky = {
            times={ [1] = 2.0, [2] = 1.0, [3] = 0.50 },
            uses = 30,
            maxlevel = 3,
            },
        },
        damage_groups = { fleshy = 5 },
    },
    sound = { breaks = "default_tool_breaks" },
    groups = { pickaxe = 1 }
})

-------------------------------------------------------------------------------
--Meteorite
-------------------------------------------------------------------------------

core.register_tool(mod_name .. ":sword_meteorite", {
    description = "Meteorite Sword",
    inventory_image = mod_name .. "_meteorite_sword.png",
    tool_capabilities = {
        full_punch_interval = 0.7,
        max_drop_level = 1,
        groupcaps = {
            snappy = {
            times = { [1] = 1.90, [2] = 0.90, [3] = 0.30 },
            uses = 40,
            maxlevel = 3,
            },
        },
        damage_groups = { fleshy = 8 },
    },
    sound = { breaks = "default_tool_breaks" },
    groups = { sword = 1 }
})

core.register_tool(mod_name .. ":axe_meteorite", {
    description = "Meteorite Axe",
    inventory_image = mod_name .. "_meteorite_axe.png",
    tool_capabilities = {
        full_punch_interval = 0.9,
        max_drop_level = 1,
        groupcaps = {
            choppy = {
            times = { [1] = 2.10, [2] = 0.90, [3] = 0.50 },
            uses = 30,
            maxlevel = 3,
            },
        },
        damage_groups = { fleshy = 7 },
    },
    sound = { breaks = "default_tool_breaks" },
    groups = { axe = 1 }
})

core.register_tool(mod_name .. ":shovel_meteorite", {
    description = "Meteorite Shovel",
    inventory_image = mod_name .. "_meteorite_shovel.png",
    wield_image = mod_name .. "_meteorite_shovel.png^[transformR90",
    tool_capabilities = {
        full_punch_interval = 1.0,
        max_drop_level = 1,
        groupcaps = {
            crumbly = {
            times={ [1] = 1.10, [2] = 0.50, [3] = 0.30 },
            uses = 30,
            maxlevel = 3,
            },
        },
        damage_groups = { fleshy = 4 },
    },
    sound = { breaks = "default_tool_breaks" },
    groups = { shovel = 1 }
})

core.register_tool(mod_name .. ":pick_meteorite", {
    description = "Meteorite Pickaxe",
    inventory_image = mod_name .. "_meteorite_pickaxe.png",
    tool_capabilities = {
        full_punch_interval = 0.9,
        max_drop_level = 3,
        groupcaps = {
            cracky = {
            times={ [1] = 2.0, [2] = 1.0, [3] = 0.50 },
            uses = 30,
            maxlevel = 3,
            },
        },
        damage_groups = { fleshy = 5 },
    },
    sound = { breaks = "default_tool_breaks" },
    groups = { pickaxe = 1 }
})
