local mod_name = core.get_current_modname()

-------------------------------------------------------------------------------
--Ores
-------------------------------------------------------------------------------

core.register_node(mod_name .. ":sand_with_caliche", {
    description = "Caliche Sand",
    tiles = {
        "default_sand.png^" .. mod_name .. "_caliche_overlay.png",
    },
    groups = {
        crumbly = 3,
        falling_node = 1,
        sand = 1,
    },
    drop = {
        max_items = 1,
        items = {
            {
                rarity = 1,
                items = {
                    "default:sand",
                    mod_name .. ":caliche 4",
                },
            },
        }
    },
    sounds = default.node_sound_sand_defaults(),
})

core.register_node(mod_name .. ":stone_with_tungsten", {
    description = "Tungsten Ore",
    tiles = {
        "default_stone.png^" .. mod_name .. "_tungsten_overlay.png",
    },
    groups = {
        cracky = 2,
    },
    drop = mod_name .. ":tungsten",
    sounds = default.node_sound_stone_defaults(),
})

core.register_node(mod_name .. ":stone_with_adamantium", {
    description = "Adamantium Ore",
    tiles = {
        "default_stone.png^" .. mod_name .. "_adamantium_overlay.png",
    },
    groups = {
        cracky = 2,
    },
    drop = mod_name .. ":adamantium",
    sounds = default.node_sound_stone_defaults(),
})

core.register_node(mod_name .. ":stone_with_saltpeter", {
    description = "Saltpeter Stone",
    tiles = {
        "default_stone.png^" .. mod_name .. "_saltpeter_overlay.png",
        },
    groups = {
        cracky = 2,
    },
    drop = mod_name .. ":saltpeter",
    sounds = default.node_sound_stone_defaults(),
})

-------------------------------------------------------------------------------
--Blocks
-------------------------------------------------------------------------------

core.register_node(mod_name .. ":tungsten_block", {
    description = "Tungsten Block",
    tiles = {
        mod_name .. "_tungsten_block.png",
    },
    is_ground_content = false,
    groups = {
        cracky = 1,
        level = 3,
    },
    sounds = default.node_sound_metal_defaults(),
})

core.register_node(mod_name .. ":adamantium_block", {
    description = "Adamantium Block",
    tiles = {
        mod_name .. "_adamantium_block.png",
    },
    is_ground_content = false,
    groups = {
        cracky = 1,
        level = 3,
    },
    sounds = default.node_sound_metal_defaults(),
})

core.register_node(mod_name .. ":heat_resistant_alloy_block", {
    description = "Heat Resistant Alloy Block",
    tiles = {
        mod_name .. "_heat_resistant_alloy_block.png",
    },
    is_ground_content = false,
    groups = {
        cracky = 1,
        level = 3,
    },
    sounds = default.node_sound_metal_defaults(),
})
