local mod_name = core.get_current_modname()

-------------------------------------------------------------------------------
--Tungsten
-------------------------------------------------------------------------------

core.register_tool(mod_name .. ":sword_tungsten", {
    description = "Tungsten Sword",
    inventory_image = mod_name .. "_tungsten_sword.png",
    tool_capabilities = {
        full_punch_interval = 0.7,
        max_drop_level = 1,
        groupcaps = {
            snappy = {
            times = { [1] = 1.90, [2] = 0.90, [3] = 0.30 },
            uses = 40,
            maxlevel = 3,
            },
        },
        damage_groups = { fleshy = 8 },
    },
    sound = { breaks = "default_tool_breaks" },
    groups = { sword = 1 }
})

core.register_tool(mod_name .. ":axe_tungsten", {
    description = "Tungsten Axe",
    inventory_image = mod_name .. "_tungsten_axe.png",
    tool_capabilities = {
        full_punch_interval = 0.9,
        max_drop_level = 1,
        groupcaps = {
            choppy = {
            times = { [1] = 2.10, [2] = 0.90, [3] = 0.50 },
            uses = 30,
            maxlevel = 3,
            },
        },
        damage_groups = { fleshy = 7 },
    },
    sound = { breaks = "default_tool_breaks" },
    groups = { axe = 1 }
})

core.register_tool(mod_name .. ":shovel_tungsten", {
    description = "Tungsten Shovel",
    inventory_image = mod_name .. "_tungsten_shovel.png",
    wield_image = mod_name .. "_tungsten_shovel.png^[transformR90",
    tool_capabilities = {
        full_punch_interval = 1.0,
        max_drop_level = 1,
        groupcaps = {
            crumbly = {
            times={ [1] = 1.10, [2] = 0.50, [3] = 0.30 },
            uses = 30,
            maxlevel = 3,
            },
        },
        damage_groups = { fleshy = 4 },
    },
    sound = { breaks = "default_tool_breaks" },
    groups = { shovel = 1 }
})

core.register_tool(mod_name .. ":pick_tungsten", {
    description = "Tungsten Pickaxe",
    inventory_image = mod_name .. "_tungsten_pickaxe.png",
    tool_capabilities = {
        full_punch_interval = 0.9,
        max_drop_level = 3,
        groupcaps = {
            cracky = {
            times={ [1] = 2.0, [2] = 1.0, [3] = 0.50 },
            uses = 30,
            maxlevel = 3,
            },
        },
        damage_groups = { fleshy = 5 },
    },
    sound = { breaks = "default_tool_breaks" },
    groups = { pickaxe = 1 }
})

-------------------------------------------------------------------------------
--Adamantium
-------------------------------------------------------------------------------

core.register_tool(mod_name .. ":sword_adamantium", {
    description = "Adamantium Sword",
    inventory_image = mod_name .. "_adamantium_sword.png",
    tool_capabilities = {
        full_punch_interval = 0.7,
        max_drop_level = 1,
        groupcaps = {
            snappy = {
            times = { [1] = 1.90, [2] = 0.90, [3] = 0.30 },
            uses = 40,
            maxlevel = 3,
            },
        },
        damage_groups = { fleshy = 8 },
    },
    sound = { breaks = "default_tool_breaks" },
    groups = { sword = 1 }
})

core.register_tool(mod_name .. ":axe_adamantium", {
    description = "Adamantium Axe",
    inventory_image = mod_name .. "_adamantium_axe.png",
    tool_capabilities = {
        full_punch_interval = 0.9,
        max_drop_level = 1,
        groupcaps = {
            choppy = {
            times = { [1] = 2.10, [2] = 0.90, [3] = 0.50 },
            uses = 30,
            maxlevel = 3,
            },
        },
        damage_groups = { fleshy = 7 },
    },
    sound = { breaks = "default_tool_breaks" },
    groups = { axe = 1 }
})

core.register_tool(mod_name .. ":shovel_adamantium", {
    description = "Adamantium Shovel",
    inventory_image = mod_name .. "_adamantium_shovel.png",
    wield_image = mod_name .. "_adamantium_shovel.png^[transformR90",
    tool_capabilities = {
        full_punch_interval = 1.0,
        max_drop_level = 1,
        groupcaps = {
            crumbly = {
            times={ [1] = 1.10, [2] = 0.50, [3] = 0.30 },
            uses = 30,
            maxlevel = 3,
            },
        },
        damage_groups = { fleshy = 4 },
    },
    sound = { breaks = "default_tool_breaks" },
    groups = { shovel = 1 }
})

core.register_tool(mod_name .. ":pick_adamantium", {
    description = "Adamantium Pickaxe",
    inventory_image = mod_name .. "_adamantium_pickaxe.png",
    tool_capabilities = {
        full_punch_interval = 0.9,
        max_drop_level = 3,
        groupcaps = {
            cracky = {
            times={ [1] = 2.0, [2] = 1.0, [3] = 0.50 },
            uses = 30,
            maxlevel = 3,
            },
        },
        damage_groups = { fleshy = 5 },
    },
    sound = { breaks = "default_tool_breaks" },
    groups = { pickaxe = 1 }
})
