local mod_name = core.get_current_modname()

-------------------------------------------------------------------------------
--Ores
-------------------------------------------------------------------------------

core.register_node(mod_name .. ":dirt_with_amber", {
    description = "Amber Dirt",
    tiles = {
        "default_dirt.png^" .. mod_name .. "_amber_overlay.png",
    },
    groups = {
        crumbly = 3,
        soil = 1,
    },
    drop = {
        max_items = 1,
        items = {
            {
                rarity = 1,
                items = {
                    "default:dirt", mod_name .. ":amber 4",
                },
            },
        }
    },
    sounds = default.node_sound_dirt_defaults(),
})

core.register_node(mod_name .. ":stone_with_februm", {
    description = "Februm Ore",
    tiles = {
        "default_stone.png^" .. mod_name .. "_februm_overlay.png",
    },
    groups = {
        cracky = 2,
    },
    drop = mod_name .. ":februm_crystal",
    sounds = default.node_sound_stone_defaults(),
})

core.register_node(mod_name .. ":stone_with_egerum", {
    description = "Egerum Ore",
    tiles = {
        "default_stone.png^" .. mod_name .. "_egerum_overlay.png",
    },
    groups = {
        cracky = 2,
    },
    drop = mod_name .. ":egerum_crystal",
    sounds = default.node_sound_stone_defaults(),
})

core.register_node(mod_name .. ":stone_with_meteorite", {
    description = "Meteorite Ore",
    tiles = {
        "default_stone.png^" .. mod_name .. "_meteorite_overlay.png",
        },
    groups = {
        cracky = 2,
    },
    drop = mod_name .. ":meteorite",
    sounds = default.node_sound_stone_defaults(),
})

core.register_node(mod_name .. ":amber_tree", {
    description = "Amber Tree",
    tiles = {
        "default_tree_top.png",
        "default_tree_top.png",
        "default_tree.png^" .. mod_name .. "_amber_overlay.png",
    },
    paramtype2 = "facedir",
    is_ground_content = false,
    groups = {
        tree = 1,
        choppy = 2,
        oddly_breakable_by_hand = 1,
        flammable = 2,
    },
    sounds = default.node_sound_wood_defaults(),
    drop = {
        max_items = 1,
        items = {
            {
                rarity = 1,
                items = {
                    "default:tree",
                    mod_name .. ":amber 4",
                },
            },
        }
    },
    on_place = core.rotate_node
})

-------------------------------------------------------------------------------
--Blocks
-------------------------------------------------------------------------------

core.register_node(mod_name .. ":februm_block", {
    description = "Februm Block",
    tiles = {
        mod_name .. "_februm_block.png",
    },
    is_ground_content = false,
    groups = {
        cracky = 1,
        level = 3,
    },
    sounds = default.node_sound_stone_defaults(),
})

core.register_node(mod_name .. ":egerum_block", {
    description = "Egerum Block",
    tiles = {
        mod_name .. "_egerum_block.png",
    },
    is_ground_content = false,
    groups = {
        cracky = 1,
        level = 3,
    },
    sounds = default.node_sound_stone_defaults(),
})

core.register_node(mod_name .. ":amber_block", {
    description = "Amber Block",
    tiles = {
        mod_name .. "_amber_block.png",
    },
    is_ground_content = false,
    groups = {
        cracky = 1,
        level = 3,
    },
    sounds = default.node_sound_stone_defaults(),
})

core.register_node(mod_name .. ":amber_brick_block", {
    description = "Amber Brick Block",
    tiles = {
        mod_name .. "_amber_brick_block.png",
    },
    is_ground_content = false,
    groups = {
        cracky = 1,
        level = 3,
    },
    sounds = default.node_sound_stone_defaults(),
})

core.register_node(mod_name .. ":arcanite_block", {
    description = "Arcanite Block",
    tiles = {
        mod_name .. "_arcanite_block.png",
    },
    is_ground_content = false,
    groups = {
        cracky = 1,
        level = 3,
    },
    sounds = default.node_sound_stone_defaults(),
})

core.register_node(mod_name .. ":meteorite_block", {
    description = "Meteorite Block",
    tiles = {
        mod_name .. "_meteorite_block.png",
    },
    is_ground_content = false,
    groups = {
        cracky = 1,
        level = 3,
    },
    sounds = default.node_sound_metal_defaults(),
})
