local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)

core.register_decoration({
    name = mod_name .. ":amber_tree",
    deco_type = "schematic",
    place_on = {
        "default:dirt_with_snow",
        "default:dirt_with_coniferous_litter",
        "default:dirt_with_grass"
    },
    sidelen = 16,
    noise_params = {
        offset = -0.0077,
        scale = 0.015,
        spread = {x = 250, y = 250, z = 250},
        seed = 10,
        octaves = 3,
        persist = 0.66
    },
    biomes = {
        "taiga",
        "coniferous_forest",
        "deciduous_forest"
    },
    y_max = 31000,
    y_min = 0,
    rotation = "random",
    schematic = mod_path .. "/schematics/amber_tree.mts",
    flags = "place_center_x, place_center_z",
})

core.register_decoration({
    name = mod_name .. ":amber_log",
    deco_type = "schematic",
    place_on = {
        "default:dirt_with_snow",
        "default:dirt_with_coniferous_litter",
        "default:dirt_with_grass"
    },
    place_offset_y = 1,
    sidelen = 80,
    fill_ratio = 0.0005,
    biomes = {
        "taiga",
        "coniferous_forest",
        "deciduous_forest"
    },
    y_max = 31000,
    y_min = 0,
    schematic = mod_path .. "/schematics/amber_log.mts",
    flags = "place_center_x",
    rotation = "random",
    spawn_by = {
        "default:dirt_with_snow",
        "default:dirt_with_coniferous_litter",
        "default:dirt_with_grass"
    },
    num_spawn_by = 8,
})
