# Simple Meters Modpack
Modpack and API for having various indicators on player's HUD. Default pack
provides compass and watch, while temperature pack provides thermometer and
hygrometer for Simple Temperature mod.

![Screenshot](screenshot.png)

## Requirements
### Mandatory

- [Luanti](https://www.luanti.org/downloads);
- [minetest_game](https://github.com/luanti-org/minetest_game).

### Optional

- [simple_temperature](https://codeberg.org/fruitsnack/simple_temperature).

## How to use
Meters are displayed on player's HUD. To enable any specific meter, the player
needs to put an associated item in their inventory. Simply having the item in
the inventory will keep the indicator displayed on HUD.

Indicator positions will automatically rearrange depending on current player
indicators.

Default pack provides watch and compass for minetest_game.

Watch displays time. The red notch at the top indicates if it's midday or
midnight, while red and blue background on watch indicates when it's day or
night.

Compass will point to player's current spawn point. That may either be default
(0,0,0), a bed, or, if [Alone](https://codeberg.org/Codiac/alone) mod by
Codiac installed, to player's unique spawn point from this mod.

Temperature pack provides integration to
[Simple Temperature](https://codeberg.org/fruitsnack/simple_temperature/),
enabling players to see external temperature and humidity. It provides 
thermometer and hygrometer.

Thermometer will display current external (not player's) temperature, from 0
to 100.

Hygrometer will display current heat multiplier, from 0 to 1.

## Settingtypes
`simple_meters` provides configuration options, accessible either in Luanti
client settings or by putting configuration options and their values
directly into your `minetest.conf`.

Full list of options, along with their documentation and possible values
is available in this file: [settingtypes.txt](simple_meters/settingtypes.txt), 
located in `simple_meters/settingtypes.txt` in this repository.

## Integration with other mods (API)
`simple_meters` provides this public function:

```
--------------------------------------------------------------------------------

simple_meters.register_meter(def):

- def, table with following fields:

{
    item, string,     - itemstring of an item;
    weight, int,      - weight of the meter when sorting HUD placement order;
    on_update,        - function(player), where 'player' is a player_ref.
                      - this function will be polled by simple meters and must
                      - return a string with an image to replace this meter to.
}

Weight is only used to position meters around player HUD, with decreasing
weight being sorted closer to the item bar.

Note that this function won't register the actual inventory item, it will only
bind its itemstring, it must be registered separately by the caller with
'core.register_craftitem()' (otherwise the meter will be registered but
unavailable to be displayed as there's no item associated with it.)

--------------------------------------------------------------------------------
```

## License And Credits
All code and assets in this repository are made by Fruitsnack, unless stated 
or implied otherwise in:

- "License And Credits" section in README (this section);
- Individual file headers;
- Git commit history;
- Merge requests and other means of contribution (i.e. by mailing patches).

Code and text files that are made by Fruitsnack are licensed
under AGPL-3.0-only.  
Full text of the license is available in this file: 
[LICENSE-AGPL-3.0-ONLY](LICENSE-AGPL-3.0-ONLY) in this repository, or, 
alternatively, [here](https://www.gnu.org/licenses/agpl-3.0.en.html).

Assets and media files that are made by Fruitsnack are licensed
under CC-BY-SA-4.0.  
Full text of the license is available in this file: 
[LICENSE-CC-BY-SA-4.0](LICENSE-CC-BY-SA-4.0) in this repository, or, 
alternatively, [here](https://creativecommons.org/licenses/by-sa/4.0/).

`screenshot.png` was made by Fruitsnack using 
[Pixelify-Sans](https://github.com/eifetx/Pixelify-Sans) font by 
Stefie Justprince, licensed under OFL-1.1.  
Full text of the license is available in this file: 
[LICENSE-OFL-1.1](LICENSE-OFL-1.1) in this repository, or, alternatively, 
[here](https://openfontlicense.org/open-font-license-official-text/).

```
    Simple Meters - Modpack and API for Luanti and minetest_game that adds
    HUD indicators
    Copyright (C) 2025 Fruitsnack

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License version 3 as
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
```

Link to the original source code repository: 
https://codeberg.org/fruitsnack/simple_meters
