local mod_name = core.get_current_modname()

local watch_div = 32
local compass_div = 24

-------------------------------------------------------------------------------
--Watch
-------------------------------------------------------------------------------

simple_meters.register_meter({
    item = mod_name .. ":watch",
    weight = 110,
    on_update = function(player)

        local time = core.get_timeofday() * watch_div

        return mod_name .. "_watch_" .. math.max(1, math.ceil(time)) .. ".png"

    end,

})

core.register_craftitem(mod_name .. ":watch", {
    description = "Watch",
    inventory_image = mod_name .. "_watch_inv.png",
    stack_max = 1,
})

core.register_craft({
    output = mod_name .. ":watch",
    recipe = {
        {"", "default:steel_ingot", ""},
        {"default:steel_ingot", "default:diamond", "default:steel_ingot"},
        {"", "default:steel_ingot", ""},
    },
})

-------------------------------------------------------------------------------
--Compass
-------------------------------------------------------------------------------

local target_func = function(player, name)
    if beds.spawn[name] then
        return beds.spawn[name]
    else
        return { x = 0, y = 0, z = 0 }
    end
end

if core.get_modpath("alone") then
    target_func = function(player, name)
        if beds.spawn[name] then
            return beds.spawn[name]
        else
            local default = { x = 0, y = 0, z = 0 }
            local meta = player:get_meta():get_string("alone:spawn")
            if meta and meta ~= "" then
                local pos = core.string_to_pos(meta)
                if pos then
                    return pos
                else
                    return default
                end
            else
                return default
            end
        end
    end
end

simple_meters.register_meter({
    item = mod_name .. ":compass",
    weight = 50,
    on_update = function(player)

        local name = player:get_player_name()
        local pos = player:get_pos()
        local dir = math.deg(player:get_look_horizontal())

        local target = target_func(player, name)

        local angle_to_north = math.deg(
        math.atan2(target.x - pos.x, target.z - pos.z))

        local angle = (angle_to_north + dir) % 360

        local id = math.max(1, math.ceil(angle / (360 / compass_div)))

        return mod_name .. "_compass_" .. id .. ".png"
    end,
})



core.register_craftitem(mod_name .. ":compass", {
    description = "Compass",
    inventory_image = mod_name .. "_compass_inv.png",
    stack_max = 1,
})

core.register_craft({
    output = mod_name .. ":compass",
    recipe = {
        {"", "default:gold_ingot", ""},
        {"default:gold_ingot", "default:mese_crystal", "default:gold_ingot"},
        {"", "default:gold_ingot", ""},
    },
})
