local mod_name = core.get_current_modname()

local divisions = 11

-------------------------------------------------------------------------------
--Thermometer
-------------------------------------------------------------------------------

local max_heat = tonumber(
core.settings:get("simple_temperature_max_temp")) or 100

simple_meters.register_meter({
    item = mod_name .. ":thermometer",
    weight = 150,

    on_update = function(player)

        local name = player:get_player_name()
        local stats = simple_temperature.get_player_stats(name)

        local heat = 50
        if stats then
            heat = stats.ext_stats.heat
        end

        local ret = math.max(1, math.ceil(heat / (max_heat / divisions)))

        return mod_name .. "_thermometer_" .. ret .. ".png"
    end,
})

core.register_craftitem(mod_name .. ":thermometer", {
    description = "Thermometer",
    inventory_image = mod_name .. "_thermometer_inv.png",
    stack_max = 1,
})

core.register_craft({
    output = mod_name .. ":thermometer",
    recipe = {
        {"default:glass", "dye:dye_red", "default:glass"},
        {"default:glass", "bucket:bucket_water", "default:glass"},
        {"", "default:gold_ingot", ""},
    },
    replacements = {{"bucket:bucket_water", "bucket:bucket_empty"}},
})

-------------------------------------------------------------------------------
--Humidity meter
-------------------------------------------------------------------------------

simple_meters.register_meter({
    item = mod_name .. ":hygrometer",
    weight = 200,

    on_update = function(player)

        local name = player:get_player_name()
        local stats = simple_temperature.get_player_stats(name)

        local mult = 0.5
        if stats then
            mult = stats.ext_stats.heat_multiplier
        end

        local ret = math.max(1, math.ceil(mult * divisions))

        return mod_name .. "_hygrometer_" .. ret .. ".png"
    end,
})

core.register_craftitem(mod_name .. ":hygrometer", {
    description = "Hygrometer",
    inventory_image = mod_name .. "_hygrometer_inv.png",
    stack_max = 1,
})

core.register_craft({
    output = mod_name .. "hygrometer",
    recipe = {
        {"default:glass", "dye:dye_blue", "default:glass"},
        {"default:glass", "bucket:bucket_water", "default:glass"},
        {"", "default:steel_ingot", ""},
    },
    replacements = {{"bucket:bucket_water", "bucket:bucket_empty"}},
})
