# Simple MOTD
A simple welcome screen mod with an option to grand privileges upon agreeing
to the rules.

![Screenshot](screenshot.png)

## Requirements
### Mandatory

- [Luanti](https://www.luanti.org/downloads);

### Optional

- [sfinv_buttons](https://codeberg.org/Wuzzy/minetest_sfinv_buttons).

## How to use
Mod displays a welcome screen with (rules, information, anything you like) 
to new players and asks them to accept (or decline) it.  
Players who decline it are not granted privileges specified in the mod 
configuration.  

To setup your own rules and list of privileges:

- Duplicate the `rules.lua_example` file in the root of the mod directory;
- Rename it to `rules.lua`;
- Adjust it to your liking;
- Remove privileges that you want to be granted by this mod from 
`default_privs` config option in your `minetest.conf` server configuration 
file.

The welcome screen can be accessed again by either using `/rules` chat
command, or, if you have 
[sfinv_buttons](https://codeberg.org/Wuzzy/minetest_sfinv_buttons) installed,
it can be found at `Inventory ("i")->More->Show Rules` button.

## Integration with other mods (API)
Mod provides one public function:
```
--------------------------------------------------------------------------------

simple_motd.show_rules(name):

- name, string, name of the player to show the welcome screen to.

--------------------------------------------------------------------------------
```

## License And Credits
All code and assets in this repository are made by Fruitsnack, unless stated 
or implied otherwise in:

- "License And Credits" section in README (this section);
- Individual file headers;
- Git commit history;
- Merge requests and other means of contribution (i.e. by mailing patches).

Code and text files that are made by Fruitsnack are licensed
under AGPL-3.0-only.  
Full text of the license is available in this file: 
[LICENSE-AGPL-3.0-ONLY](LICENSE-AGPL-3.0-ONLY) in this repository, or, 
alternatively, [here](https://www.gnu.org/licenses/agpl-3.0.en.html).

Assets and media files that are made by Fruitsnack are licensed
under CC-BY-SA-4.0.  
Full text of the license is available in this file: 
[LICENSE-CC-BY-SA-4.0](LICENSE-CC-BY-SA-4.0) in this repository, or, 
alternatively, [here](https://creativecommons.org/licenses/by-sa/4.0/).

`screenshot.png` was made by Fruitsnack using 
[Pixelify-Sans](https://github.com/eifetx/Pixelify-Sans) font by 
Stefie Justprince, licensed under OFL-1.1.  
Full text of the license is available in this file: 
[LICENSE-OFL-1.1](LICENSE-OFL-1.1) in this repository, or, alternatively, 
[here](https://openfontlicense.org/open-font-license-official-text/).

```
    Simple MOTD - Luanti welcome screen with an option to grant privileges
    Copyright (C) 2025 Fruitsnack

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License version 3 as
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
```

Link to the original source code repository: 
https://codeberg.org/fruitsnack/simple_motd
