-------------------------------------------------------------------------------
--Default Data Structures
-------------------------------------------------------------------------------

simple_motd = {}

-------------------------------------------------------------------------------
--Internal Variables
-------------------------------------------------------------------------------

local mod_name = core.get_current_modname()

simple_motd.rules_text = "Please set up your rules.lua file."
simple_motd.warning_text = "Please set up your rules.lua file."
simple_motd.grant_privs = { "interact" }

local rule_path = core.get_modpath(mod_name) .. "/rules.lua"
local file = io.open(rule_path, "r")

if file then
    dofile(rule_path)
    io.close(file)
end

-------------------------------------------------------------------------------
--Utils
-------------------------------------------------------------------------------

local function msg(level, input)
    core.log(level, "[" .. mod_name .. "] " .. input)
end

local function replace_newlines(text)
    local tmp = core.formspec_escape(text)
    tmp = string.gsub(tmp, "\n", ",")
    return tmp
end

-------------------------------------------------------------------------------
--Formspecs
-------------------------------------------------------------------------------

local function gen_init_formspec()

    local formspec = {}

    formspec[#formspec + 1] = "size[12,10]"
    formspec[#formspec + 1] = "tablecolumns[text]"
    formspec[#formspec + 1] = "tableoptions[background=#000000A0;"
    formspec[#formspec + 1] = "highlight=#000000A0;border=false]"
    formspec[#formspec + 1] = "table[1,0.2;9.85,9;"
    formspec[#formspec + 1] = mod_name
    formspec[#formspec + 1] = "_initial;"
    formspec[#formspec + 1] = replace_newlines(simple_motd.rules_text)
    formspec[#formspec + 1] = "]"
    formspec[#formspec + 1] = "button[3.75,9.65;2,0.3;decline;Decline]"
    formspec[#formspec + 1] = "button_exit[6.25,9.65;2,0.3;accept;Accept]"

    return table.concat(formspec)
end

local function gen_agreed_formspec()

    local formspec = {}

    formspec[#formspec + 1] = "size[12,10]"
    formspec[#formspec + 1] = "tablecolumns[text]"
    formspec[#formspec + 1] = "tableoptions[background=#000000A0;"
    formspec[#formspec + 1] = "highlight=#000000A0;border=false]"
    formspec[#formspec + 1] = "table[1,0.2;9.85,9;"
    formspec[#formspec + 1] = mod_name
    formspec[#formspec + 1] = "_agreed;"
    formspec[#formspec + 1] = replace_newlines(simple_motd.rules_text)
    formspec[#formspec + 1] = "]"
    formspec[#formspec + 1] = "button_exit[5,9.65;2,0.3;close;Close]"
    
    return table.concat(formspec)
end

local function gen_warning_formspec()

    local formspec = {}

    formspec[#formspec + 1] = "size[6,4]"
    formspec[#formspec + 1] = "tablecolumns[text]"
    formspec[#formspec + 1] = "tableoptions[background=#000000A0;"
    formspec[#formspec + 1] = "highlight=#000000A0;border=false]"
    formspec[#formspec + 1] = "table[0.25,0.1;5.35,3.15;"
    formspec[#formspec + 1] = mod_name
    formspec[#formspec + 1] = "_warning;"
    formspec[#formspec + 1] = replace_newlines(simple_motd.warning_text)
    formspec[#formspec + 1] = "]"
    formspec[#formspec + 1] = "button_exit[2,3.7;2,0.3;accept;Accept]"

    return table.concat(formspec)
end

local initial_formspec = gen_init_formspec()
local agreed_formspec = gen_agreed_formspec()
local warning_formspec = gen_warning_formspec()


-------------------------------------------------------------------------------
--Registrations
-------------------------------------------------------------------------------

core.register_on_joinplayer(function(player)

    local name = player:get_player_name()
    local player_privs = core.get_player_privs(name)

    for _,v in pairs(simple_motd.grant_privs) do

        if not player_privs[v] then
            core.show_formspec(
                name,
                mod_name .. "_initial",
                initial_formspec)
            break
        end

    end

end)

core.register_on_player_receive_fields(function(player, formname, fields)

    if formname ~= mod_name .. "_initial" then return end

    local name = player:get_player_name()

    if fields.accept then

        local player_privs = core.get_player_privs(name)

        for _, v in pairs(simple_motd.grant_privs) do
            player_privs[v] = true
            core.set_player_privs(name, player_privs)
        end

        msg("action", name .. " agreed to the rules.")

    elseif fields.quit or fields.decline then

        core.show_formspec(name, mod_name .. "_warn", warning_formspec)

    end
end)

core.register_chatcommand("rules",{
    params = "",
    description = "Shows the server rules",
    privs = {
        shout = true
    },
    func = simple_motd.show_rules
})

-------------------------------------------------------------------------------
--API
-------------------------------------------------------------------------------

simple_motd.show_rules = function(name)

    local privs
    local user

    if type(name) ~= "string" and name:is_player() then
        user = name:get_player_name()
        privs = core.get_player_privs(user)
    else
        user = name
        privs = core.get_player_privs(name)
    end

    for _,v in pairs(simple_motd.grant_privs) do

        if not privs[v] then
            core.show_formspec(
                user,
                mod_name .. "_initial",
                initial_formspec)
            break
        else
            core.show_formspec(
                user,
                mod_name .. "_agreed",
                agreed_formspec)
        end

    end
end

-------------------------------------------------------------------------------
--Mod Integration
-------------------------------------------------------------------------------

if core.get_modpath("sfinv_buttons") then
    sfinv_buttons.register_button(mod_name .."_button", 
    {
        title = "Server Rules",
        action = simple_motd.show_rules,
        tooltip = "Show server rules",
        image = mod_name .. "_rules_thumbnail.png",
    })
end
