-------------------------------------------------------------------------------
--Variables
-------------------------------------------------------------------------------

local y_min = tonumber(
    core.settings:get("simple_music_overworld_surface_min_y")) or -16
local y_max = 31000

if core.get_modpath("cloudlands") then
    y_min = tonumber(core.settings:get("cloudlands_altitude"))
    or 200
end

local gain = 0.7

-------------------------------------------------------------------------------
--Day Music
-------------------------------------------------------------------------------

simple_music.register_track({
    name = "the_other_side_of_the_door",
    length = 168,
    gain = gain,
    day = true,
    night = false,
    ymin = y_min,
    ymax = y_max,
})

simple_music.register_track({
    name = "on_the_shore",
    length = 101,
    gain = gain,
    day = true,
    night = false,
    ymin = y_min,
    ymax = y_max,
})

simple_music.register_track({
    name = "dreamy_flashback",
    length = 127,
    gain = gain,
    day = true,
    night = false,
    ymin = y_min,
    ymax = y_max,
})

-------------------------------------------------------------------------------
--Night Music
-------------------------------------------------------------------------------

simple_music.register_track({
    name = "ossuary_1_a_beginning",
    length = 189,
    gain = gain,
    day = false,
    night = true,
    ymin = y_min,
    ymax = y_max,
})

simple_music.register_track({
    name = "mirage",
    length = 241,
    gain = gain,
    day = false,
    night = true,
    ymin = y_min,
    ymax = y_max,
})

simple_music.register_track({
    name = "wizardtorium",
    length = 208,
    gain = gain,
    day = false,
    night = true,
    ymin = y_min,
    ymax = y_max,
})
