-------------------------------------------------------------------------------
--Settingtypes
-------------------------------------------------------------------------------

local mod_name = "simple_music_overworld"

local function get_setting(name, def)

    if type(def) == "boolean" then
        local inp = core.settings:get_bool(mod_name .. "_" .. name, def)
        return inp
    elseif type(def) == "string" or type(def) == "table" then
        local inp = core.settings:get(mod_name .. "_" .. name) or def
        return inp
    else
        local inp = core.settings:get(mod_name .. "_" .. name) or def
        return tonumber(inp)
    end

end

local surface_y_min = get_setting("surface_min_y", -16)
local surface_y_max = get_setting("surface_max_y", 31000)
local underground_y_min = get_setting("underground_min_y", -31000)
local underground_y_max = get_setting("underground_max_y", -16)

-------------------------------------------------------------------------------
--Mod Integrations
-------------------------------------------------------------------------------

if core.get_modpath("cloudlands") and 
core.get_modpath("simple_music_cloudlands") then
    surface_y_max = tonumber(core.settings:get("cloudlands_altitude"))
    or 200
end

if core.get_modpath("nether") and 
core.get_modpath("simple_music_nether") then
    underground_y_min = tonumber(core.settings:get("nether_depth_ymax"))
    or -5000
end

if core.get_modpath("df_caverns") and
core.get_modpath("simple_music_df_caverns") then
    underground_y_min = tonumber(core.settings:get("dfcaverns_ymax"))
    or -193
end

local gain = 0.7

-------------------------------------------------------------------------------
--Day Music
-------------------------------------------------------------------------------

simple_music.register_track({
    name = "time_passes",
    length = 71,
    gain = gain,
    day = true,
    night = false,
    ymin = surface_y_min,
    ymax = surface_y_max,
})

simple_music.register_track({
    name = "gymnopedie_no_3",
    length = 146,
    gain = gain,
    day = true,
    night = false,
    ymin = surface_y_min,
    ymax = surface_y_max,
})

simple_music.register_track({
    name = "energizing",
    length = 134,
    gain = gain,
    day = true,
    night = false,
    ymin = surface_y_min,
    ymax = surface_y_max,
})

simple_music.register_track({
    name = "feather_waltz",
    length = 91,
    gain = gain,
    day = true,
    night = false,
    ymin = surface_y_min,
    ymax = surface_y_max,
})

simple_music.register_track({
    name = "water_lily",
    length = 145,
    gain = gain,
    day = true,
    night = false,
    ymin = surface_y_min,
    ymax = surface_y_max,
})

simple_music.register_track({
    name = "dreams_become_real",
    length = 411,
    gain = gain,
    day = true,
    night = false,
    ymin = surface_y_min,
    ymax = surface_y_max,
})

simple_music.register_track({
    name = "mesmerize",
    length = 425,
    gain = gain,
    day = true,
    night = false,
    ymin = surface_y_min,
    ymax = surface_y_max,
})

-------------------------------------------------------------------------------
--Night Music
-------------------------------------------------------------------------------

simple_music.register_track({
    name = "smoother_move",
    length = 279,
    gain = gain,
    day = false,
    night = true,
    ymin = surface_y_min,
    ymax = surface_y_max,
})

simple_music.register_track({
    name = "lasting_hope",
    length = 144,
    gain = gain,
    day = false,
    night = true,
    ymin = surface_y_min,
    ymax = surface_y_max,
})

simple_music.register_track({
    name = "immersed",
    length = 249,
    gain = gain,
    day = false,
    night = true,
    ymin = surface_y_min,
    ymax = surface_y_max,
})

simple_music.register_track({
    name = "despair_and_triumph",
    length = 286,
    gain = gain,
    day = false,
    night = true,
    ymin = surface_y_min,
    ymax = surface_y_max,
})

-------------------------------------------------------------------------------
--Underground Music
-------------------------------------------------------------------------------

simple_music.register_track({
    name = "infados",
    length = 224,
    gain = gain,
    day = true,
    night = true,
    ymin = underground_y_min,
    ymax = underground_y_max,
})

simple_music.register_track({
    name = "long_note_two",
    length = 463,
    gain = gain,
    day = true,
    night = true,
    ymin = underground_y_min,
    ymax = underground_y_max,
})

simple_music.register_track({
    name = "road_to_hell",
    length = 112,
    gain = gain,
    day = true,
    night = true,
    ymin = underground_y_min,
    ymax = underground_y_max,
})

simple_music.register_track({
    name = "rites",
    length = 127,
    gain = gain,
    day = true,
    night = true,
    ymin = underground_y_min,
    ymax = underground_y_max,
})
