# Simple Music Modpack
Music modpack with API for easy in-game music playback and custom track 
registration.

Modpack features a total of 34 tracks composed by Kevin McLeod.

![Screenshot](screenshot.png)

## Requirements
### Mandatory

- [Luanti](https://www.luanti.org/downloads).

### Optional

- [minetest_game](https://github.com/luanti-org/minetest_game);
- [sfinv_buttons](https://codeberg.org/Wuzzy/minetest_sfinv_buttons);
- [df_caverns](https://github.com/FaceDeer/dfcaverns);
- [Nether](https://github.com/minetest-mods/nether);
- [Cloudlands](https://github.com/Treer/cloudlands).

## How to use
Simply install and activate the modpack. Music will be played automatically
according to player's environment (time, elevation). 

Settings can be accessed by using the `/musicsettings` chat command. 
Alternatively, if 
[sfinv_buttons](https://codeberg.org/Wuzzy/minetest_sfinv_buttons) is installed,
music settings can be accessed from inventory("i")->more->music settings. For
now, the settings menu provides a volume slider individual for every player and
also buttons to manually stop or trigger playback.

Modpack provides several music packs:

- Overworld: default music pack with calm background music, suitable for 
minetest_game and similar;
- df_caverns: modpack with music for
[df_caverns](https://github.com/FaceDeer/dfcaverns) by FaceDeer, featuring
8 dark, mysterious music that fits deep underground exploration;
- Cloudlands: modpack with music for
[Cloudlands](https://github.com/Treer/cloudlands) by Treer, featuring 6 more
mysterious, magical music that fits floating islands;
- Nether: modpack with music for
[Nether](https://github.com/minetest-mods/nether) by PilzAdam, featuring 5 very
dark, horror-like music that fits Nether.

Music packs mentioned above will automatically use default or custom-set
height limits for each respective mod.

It's not required to have actual mods installed, music packs mentioned above
will work regardless, but they will only work at respective default elevations.

Overworld and Cloudlands packs also have their music split for day/night time,
while df_caverns and Nether have elevation-based music.

All music has been re-encoded to a samplerate of 22050 Hz and converted from 
stereo to mono to preserve space. This results in noticeably poorer audio
quality, however the original size of all soundtracks used in this modpack was
around 400 mb, which is unsuitable for multiplayer (as every player will have
to download all assets from this modpack on connecting). Re-encoded media, on
the other hand, occupies only ~28 mb, which is manageable.

The following command was used:
```
ffmpeg -i in.mp3 -ar 22050 -ac 1 -c:a libvorbis -map_metadata -1 -vn out.ogg
```

## Settingtypes
`simple_music` provides configuration options, accessible either in Luanti
client settings or by putting configuration options and their values
directly into your `minetest.conf`.

Full list of options, along with their documentation and possible values
is available in this file: [settingtypes.txt](simple_emojis/settingtypes.txt), 
located in `simple_music/settingtypes.txt` in this repository.

## Integration with other mods (API)
`simple_music` provides this public function:

```
--------------------------------------------------------------------------------

simple_music.register_track({
    name = "my_track",
    length = 200,
    gain = 1,
    day = true,
    night = true,
    ymin = 0,
    ymax = 31000,
})

- name - name of the sound file in your mod sounds folder, without extension;
- length - length of the track in seconds;
- gain - volume, value from 0 to 1;
- day - track will be played at day;
- night - track will be played at night;
- ymin - minimum elevation for track to play;
- ymax - maximum elevation for track to play.

--------------------------------------------------------------------------------
```

## License And Credits
All code in this repository is made by Fruitsnack, unless stated 
or implied otherwise in:

- "License And Credits" section in README (this section);
- Individual file headers;
- Git commit history;
- Merge requests and other means of contribution (i.e. by mailing patches).

Code and text files that are made by Fruitsnack are licensed
under AGPL-3.0-only.  
Full text of the license is available in this file: 
[LICENSE-AGPL-3.0-ONLY](LICENSE-AGPL-3.0-ONLY) in this repository, or, 
alternatively, [here](https://www.gnu.org/licenses/agpl-3.0.en.html).

All files (audio tracks) located in `simple_music_default/sounds` were made by 
KevinMcLeod and licensed under CC-BY-4.0.  
Full text of the license is available in this file: 
[LICENSE-CC-BY-4.0](LICENSE-CC-BY-4.0) in this repository, or, 
alternatively, [here](https://creativecommons.org/licenses/by/4.0/).  
Original music can be found 
[here](https://incompetech.com/music/royalty-free/music.html).

Assets and media files that are made by Fruitsnack are licensed
under CC-BY-SA-4.0.  
Full text of the license is available in this file: 
[LICENSE-CC-BY-SA-4.0](LICENSE-CC-BY-SA-4.0) in this repository, or, 
alternatively, [here](https://creativecommons.org/licenses/by-sa/4.0/).

`screenshot.png` was made by Fruitsnack using 
[Pixelify-Sans](https://github.com/eifetx/Pixelify-Sans) font by 
Stefie Justprince, licensed under OFL-1.1.  
Full text of the license is available in this file: 
[LICENSE-OFL-1.1](LICENSE-OFL-1.1) in this repository, or, alternatively, 
[here](https://openfontlicense.org/open-font-license-official-text/).

```
    Simple Music - Modpack for Luanti that adds music
    Copyright (C) 2025 Fruitsnack

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License version 3 as
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
```

Link to the original source code repository: 
https://codeberg.org/fruitsnack/simple_music
