# Simple Parties
Configurable and easy to use party mod for Luanti and minetest_game.

![Screenshot](screenshot.png)

## Requirements
### Mandatory

- [Luanti](https://www.luanti.org/downloads);
- [minetest_game](https://github.com/luanti-org/minetest_game).

## Conflicts
Mod might conflict with other mods that modify player nametag.

## How to use
Open inventory (`i`) and navigate to a new tab called `Parties`.
The tab provides party management functions in an easy to use interface.

Parties provide four default ranks with varying privileges:

- Member: default rank when joining;
- Manager: can invite, cancel invites and kick;
- Leader: same as manager + change party info and color, promote/demote;
- Founder: default rank when creating a party, has all privileges.

Only founder has the folllowing privileges:
- Set new founder;
- Rename party;
- Disband party.

Kicking and promoting works for all ranks above member, but current
rank can only kick or promote/demote up to a rank below theirs, so
managers can only kick members, leaders can kick members and managers
and also promote up to manager and so on.

When a player receives an invite, they are notified by a chat message.
To accept the invite, navigate to the inventory party tab and accept
(or reject) the invite. Multiple invites may be sent from different
parties, in which case the player can choose which one to accept.

Parties also have their own chat, visible to party members only.
To send a message to this chat, prefix your message with `/p`, for example:
```
/p Hey, how it's going?
```

Another feature are party-shared chests. Players can craft a special chest
with the following recipe:
```
 obsidian  |  obsidian  |  obsidian
------------------------------------
gold block | mese block | gold block
------------------------------------
 obsidian  |  obsidian  |  obsidian
```

This chest works in a similar way to 
[personal_storage](https://codeberg.org/fruitsnack/personal_storage).
Instead of chest content being tied to the chest, it's tied to a party,
so all party members can access shared inventory, no matter where party
chests are placed.  
That way, players will always access the same party inventory even when opening 
different party chests placed in different places.  
Similarly, if a player joins another party and tries to access the same party
chest, they will instead see shared inventory of their new party.

## Settingtypes
Mod provides configuration options, accessible either in Luanti
client settings or by putting configuration options and their values
directly into your `minetest.conf`.

Full list of options, along with their documentation and possible values
is available in this file: [settingtypes.txt](settingtypes.txt) in this 
repository.

## Integration with other mods (API)
Mod provides these public functions:

```
--------------------------------------------------------------------------------

simple_parties.get_player_party(name):

- name, string, name of the player.

Function returns name of party player is currently in, or nil if player
isn't in a party.
    
--------------------------------------------------------------------------------

simple_parties.get_player_invites(name):

- name, string, name of the player.

Function returns a table with names of parties player was invited in, or nil
if there is none.

--------------------------------------------------------------------------------

simple_parties.get_party_info(party_name):

- party_name, string, name of the party.

Function returns table with party data, or nil if there's none.

Party table structure:

{
    members = {{name = name, rank = 4},...},   --Player names and ranks
    invites = {...},                           --Invites for other players
    name_color = {r = 255, g = 255, b = 255},  --Color of party name
    info = "",                                 --Text displayed in info field
}

--------------------------------------------------------------------------------

simple_parties.get_party_list():

Function returns a table with names of all existing parties, or empty table
if there's none.
    
--------------------------------------------------------------------------------
```

## License And Credits
All code and assets in this repository are made by Fruitsnack, unless stated 
or implied otherwise in:

- "License And Credits" section in README (this section);
- Individual file headers;
- Git commit history;
- Merge requests and other means of contribution (i.e. by mailing patches).

Code and text files that are made by Fruitsnack are licensed
under AGPL-3.0-only.  
Full text of the license is available in this file: 
[LICENSE-AGPL-3.0-ONLY](LICENSE-AGPL-3.0-ONLY) in this repository, or, 
alternatively, [here](https://www.gnu.org/licenses/agpl-3.0.en.html).

Assets and media files that are made by Fruitsnack are licensed
under CC-BY-SA-4.0.  
Full text of the license is available in this file: 
[LICENSE-CC-BY-SA-4.0](LICENSE-CC-BY-SA-4.0) in this repository, or, 
alternatively, [here](https://creativecommons.org/licenses/by-sa/4.0/).

`screenshot.png` was made by Fruitsnack using 
[Pixelify-Sans](https://github.com/eifetx/Pixelify-Sans) font by 
Stefie Justprince, licensed under OFL-1.1.  
Full text of the license is available in this file: 
[LICENSE-OFL-1.1](LICENSE-OFL-1.1) in this repository, or, alternatively, 
[here](https://openfontlicense.org/open-font-license-official-text/).

```
    Simple Parties - Luanti mod that adds faction-like functionality
    Copyright (C) 2025 Fruitsnack

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License version 3 as
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
```

Link to the original source code repository: 
https://codeberg.org/fruitsnack/simple_parties
