# Simple Ruins Modpack
Modpack for Luanti and minetest_game that provides various ruins to explore
and loot, along with an API to register your own structures.

For now, it comes with a default pack that provides shipwrecks with loot
to spawn across the map.

![Screenshot](screenshot.png)

## Requirements
### Mandatory

- [Luanti](https://www.luanti.org/downloads);
- [minetest_game](https://github.com/luanti-org/minetest_game);
- [simple_treasures](https://codeberg.org/fruitsnack/simple_treasures).

## How to use
Simply install modpack and activate it. Structures should start spawning in
newly generated mapblocks.

Each mapblock (64 nodes by default) can only have one structure; it will be
chosen randomly from a pool of structures that fit all the spawning criteria
(chance, nodes, etc).

## Settingtypes
`simple_ruins` provides configuration options, accessible either in Luanti
client settings or by putting configuration options and their values
directly into your `minetest.conf`.

Full list of options, along with their documentation and possible values
is available in this file: [settingtypes.txt](simple_ruins/settingtypes.txt), 
located in `simple_ruins/settingtypes.txt` in this repository.

## Integration with other mods (API)
`simple_ruins` provides this public function:

```
--------------------------------------------------------------------------------

simple_ruins.register_structure = function(name, def):

- name, string, name of the structure. Prefix this with your mod name to avoid
conflicts;
- def, table with following fields:
{
    y_min = -64,                        - min y for structure to spawn;
    y_max = 3,                          - max y for structure to spawn;
    spawn_on = "default:sand",          - node to spawn the structure on;
    spawn_in = "default:water_source",  - node to spawn the structure in;
    chance = 15,                        - chance from 0 to 100 per mapblock;
    schematics = {},                    - table with one or more schematics,
                                          schematic will be chosen randomly;
    h_disp_min = -10,                   - min x and y for random horizontal
                                          displacement from the center of
                                          mapblock;
    h_disp_max = 10,                    - max x and y for random horizontal
                                          displacement from the center of
                                          mapblock;
    v_disp_min = -4,                    - min y for random vertical
                                          displacement;
    v_disp_max = -1,                    - max y for random vertical
                                          displacement;

--------------------------------------------------------------------------------
```

## License And Credits
All code and assets in this repository are made by Fruitsnack, unless stated 
or implied otherwise in:

- "License And Credits" section in README (this section);
- Individual file headers;
- Git commit history;
- Merge requests and other means of contribution (i.e. by mailing patches).

Code and text files that are made by Fruitsnack are licensed
under AGPL-3.0-only.  
Full text of the license is available in this file: 
[LICENSE-AGPL-3.0-ONLY](LICENSE-AGPL-3.0-ONLY) in this repository, or, 
alternatively, [here](https://www.gnu.org/licenses/agpl-3.0.en.html).

Assets and media files that are made by Fruitsnack are licensed
under CC-BY-SA-4.0.  
Full text of the license is available in this file: 
[LICENSE-CC-BY-SA-4.0](LICENSE-CC-BY-SA-4.0) in this repository, or, 
alternatively, [here](https://creativecommons.org/licenses/by-sa/4.0/).

`screenshot.png` was made by Fruitsnack using 
[Pixelify-Sans](https://github.com/eifetx/Pixelify-Sans) font by 
Stefie Justprince, licensed under OFL-1.1.  
Full text of the license is available in this file: 
[LICENSE-OFL-1.1](LICENSE-OFL-1.1) in this repository, or, alternatively, 
[here](https://openfontlicense.org/open-font-license-official-text/).

```
    Simple Ruins - Modpack that provides ruins and other structures for Luanti
    and minetest_game
    Copyright (C) 2025 Fruitsnack

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License version 3 as
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
```

Link to the original source code repository: 
https://codeberg.org/fruitsnack/simple_ruins
