----------------------------------------------------------------------------
--Default data structures
-------------------------------------------------------------------------------

simple_ruins = {}
local registered_ruins = {}

-------------------------------------------------------------------------------
--Settingtype initialization
-------------------------------------------------------------------------------

local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)

local function get_setting(name, def)

    if type(def) == "boolean" then
        local inp = core.settings:get_bool(mod_name .. "_" .. name, def)
        return inp
    elseif type(def) == "string" or type(def) == "table" then
        local inp = core.settings:get(mod_name .. "_" .. name) or def
        return inp
    else
        local inp = core.settings:get(mod_name .. "_" .. name) or def
        return tonumber(inp)
    end

end

local disable_spawning = get_setting("disable_spawn", false)
local global_multiplier = get_setting("global_multiplier", 1)

-------------------------------------------------------------------------------
--Internal variables
-------------------------------------------------------------------------------

local settings = {
    global_mult = global_multiplier,
}

-------------------------------------------------------------------------------
--Registrations
-------------------------------------------------------------------------------

simple_ruins.register_structure = function(name, def)

    if not name or not def or type(def) ~= "table" then
        msg("error", "Wrong or missing fields in ruin definition!")
        return
    end

    registered_ruins[name] = def
end

core.register_on_mods_loaded(function()
    for _,v in pairs(registered_ruins) do
        v.spawn_on_cid = core.get_content_id(v.spawn_on)
        v.spawn_in_cid = core.get_content_id(v.spawn_in)
    end
    core.ipc_set(mod_name .. ":ruins", registered_ruins)
    core.ipc_set(mod_name .. ":settings", settings)
end)

if not disable_spawning then
    core.register_mapgen_script(mod_path .. "/mapgen.lua")
end
