----------------------------------------------------------------------------
--Obtain parameters through IPC
-------------------------------------------------------------------------------

local mod_name = core.get_current_modname()
local registered_ruins = core.ipc_get(mod_name .. ":ruins")
local settings = core.ipc_get(mod_name .. ":settings")

-------------------------------------------------------------------------------
--Internal variables
-------------------------------------------------------------------------------

local rotations = {"0", "90", "180", "270"}
local data = {}

-------------------------------------------------------------------------------
--Main callback
-------------------------------------------------------------------------------

core.register_on_generated(function(vmanip, minp, maxp, blockseed)

    local candidates = {}
    
    for k,v in pairs(registered_ruins) do
        if v.y_min >= minp.y or v.y_max <= maxp.y then
            candidates[#candidates + 1] = k
        end
    end
    
    if #candidates == 0 then return end

    local emin, emax = vmanip:get_emerged_area()
    local area = VoxelArea:new({MinEdge = emin, MaxEdge = emax})

    vmanip:get_data(data)

    local midpoint = (maxp.x - minp.x + 1) / 2

    local can_spawn = {}

    local rng = PcgRandom(blockseed)

    for _,v in pairs(candidates) do

        local def = registered_ruins[v]

        if rng:next(0,100) <= def.chance * settings.global_mult then
            local x_disp = rng:next(def.h_disp_min, def.h_disp_max)
            local z_disp = rng:next(def.h_disp_min, def.h_disp_max)
            local y_disp = rng:next(def.v_disp_min, def.v_disp_max)

            local new_pos = {
                x = minp.x + midpoint + x_disp,
                y = 0,
                z = minp.z + midpoint + z_disp,
            }
            
            local on_node = def.spawn_on_cid
            local in_node = def.spawn_in_cid
            
            for y = minp.y, maxp.y do

                new_pos.y = y
                
                local vi = area:index(new_pos.x, new_pos.y, new_pos.z)

                if data[vi] == on_node and
                data[vi + area.ystride] == in_node then

                    new_pos.y = new_pos.y + y_disp

                    can_spawn[#can_spawn + 1] = {
                        name = v,
                        pos = new_pos
                    }

                    break

                end
            end
        end
        
    end

    if #can_spawn == 0 then return end

    local selected = can_spawn[rng:next(1, #can_spawn)]
    local def = registered_ruins[selected.name]

    local schem = def.schematics[rng:next(1, #def.schematics)]
    local rotation = rotations[rng:next(1, #rotations)]

    core.place_schematic_on_vmanip(
        vmanip,
        selected.pos,
        schem,
        rotation,
        nil,
        true,
        "place_center_x, place_center_z")

end)
