local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)

local shipwreck_def = {
    y_min = -64,
    y_max = 3,
    spawn_on = "default:sand",
    spawn_in = "default:water_source",
    chance = 15,
    schematics = {},
    h_disp_min = -10,
    h_disp_max = 10,
    v_disp_min = -4,
    v_disp_max = -1,
}

for _,v in pairs({"oak", "jungle", "pine"}) do
    for i = 1, 6 do
        table.insert(
            shipwreck_def.schematics,
            mod_path .. "/schematics/shipwreck_" .. v .. "_0" .. i .. ".mts"
        )
    end
end

simple_ruins.register_structure(mod_name .. ":shipwreck", shipwreck_def)
