# Simple Sprint
Configurable and easy-to use sprinting mod for Luanti and minetest_game that 
supports hudbars and hbhunger.  
Designed after [hbsprint](https://github.com/minetest-mods/hbsprint) by 
Tacotexmex.  
Hbsprint is great, however there's a few bugs, so I decided to write my own 
"vision" of this mod.

![Screenshot](screenshot.png)

## Requirements
### Mandatory

- [Luanti](https://www.luanti.org/downloads);
- [player_monoids](https://github.com/minetest-mods/player_monoids).

### Optional

- [hudbars](https://codeberg.org/Wuzzy/minetest_hudbars): HUD indicator;
- [hbhunger](https://codeberg.org/Wuzzy/minetest_hbhunger): hunger drain.

## Conficts
Mod conflicts with other mods that implement such functionality or bind
some actions to aux1 (E) key.

## How to use
Hold "special" key to sprint (by default it's assigned to E).  
While sprinting, your stamina will decrease, until it hits 0 and you'll no 
longer be able to sprint.  
If your stamina is lower than a threshold (specified in settingtypes), 
then you can't start sprinting.  

## Settingtypes
Mod provides configuration options, accessible either in Luanti
client settings or by putting configuration options and their values
directly into your `minetest.conf`.

Full list of options, along with their documentation and possible values
is available in this file: [settingtypes.txt](settingtypes.txt) in this 
repository.

## Integration with other mods (API)
Mod provides these public functions:

```
--------------------------------------------------------------------------------

simple_sprint.set_stamina(name, amount, add):

- name - string, name of the player;
- amount - float, amount of stamina to add/set;
- add - bool, should "amount" be added or set.

function returns new stamina amount of the player, or returns false if failed.

--------------------------------------------------------------------------------

simple_sprint.get_stamina(name):

- name - string, name of the player.

function returns amount of stamina of the player, or returns false if failed.

--------------------------------------------------------------------------------
```

## License And Credits
All code and assets in this repository are made by Fruitsnack, unless stated 
or implied otherwise in:

- "License And Credits" section in README (this section);
- Individual file headers;
- Git commit history;
- Merge requests and other means of contribution (i.e. by mailing patches).

Code and text files that are made by Fruitsnack are licensed
under AGPL-3.0-only.  
Full text of the license is available in this file: 
[LICENSE-AGPL-3.0-ONLY](LICENSE-AGPL-3.0-ONLY) in this repository, or, 
alternatively, [here](https://www.gnu.org/licenses/agpl-3.0.en.html).

Assets and media files that are made by Fruitsnack are licensed
under CC-BY-SA-4.0.  
Full text of the license is available in this file: 
[LICENSE-CC-BY-SA-4.0](LICENSE-CC-BY-SA-4.0) in this repository, or, 
alternatively, [here](https://creativecommons.org/licenses/by-sa/4.0/).

`screenshot.png` was made by Fruitsnack using 
[Pixelify-Sans](https://github.com/eifetx/Pixelify-Sans) font by 
Stefie Justprince, licensed under OFL-1.1.  
Full text of the license is available in this file: 
[LICENSE-OFL-1.1](LICENSE-OFL-1.1) in this repository, or, alternatively, 
[here](https://openfontlicense.org/open-font-license-official-text/).

```
    Simple Sprint - Luanti mod that adds sprinting
    Copyright (C) 2025 Fruitsnack

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License version 3 as
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
```

Link to the original source code repository: 
https://codeberg.org/fruitsnack/simple_sprint
