--------------------------------------------------------------------------------
--Cold Liquid Groups
--------------------------------------------------------------------------------

simple_temperature.register_liquid_node("group:water", -20)

--------------------------------------------------------------------------------
--Hot liquid Groups
--------------------------------------------------------------------------------

simple_temperature.register_liquid_node("group:lava", 100)

--------------------------------------------------------------------------------
--Hot Radiant Groups
--------------------------------------------------------------------------------

simple_temperature.register_temperature_node("group:fire", 50)
simple_temperature.register_temperature_node("group:torch", 15)
simple_temperature.register_temperature_node("group:lava", 70)

if core.get_modpath("magma_conduits") then
    simple_temperature.register_temperature_node(
    "magma_conduits:hot_cobble", 70)
    simple_temperature.register_temperature_node(
    "magma_conduits:glow_obsidian", 70)
end

if core.get_modpath("nether") then
    simple_temperature.register_temperature_node("nether:lava_crust", 70)
end
--------------------------------------------------------------------------------
--Override Zones
--------------------------------------------------------------------------------

if core.get_modpath("nether") then

    local nether_min_y =
    tonumber(core.settings:get("nether_depth_ymin")) or -11000

    local nether_max_y =
    tonumber(core.settings:get("nether_depth_ymax")) or -5000

    simple_temperature.register_override_zone(
        80,
        0.5,
        nether_min_y,
        nether_max_y)
end

if core.get_modpath("cloudlands") then

    local cloudlands_min_y =
    tonumber(core.settings:get("cloudlands_altitude")) or 200

    local cloudlands_max_y = cloudlands_min_y +
    (tonumber(core.settings:get("cloudlands_altitude_amplitude")) or 40)

    simple_temperature.register_override_zone(
        50,
        0.5,
        cloudlands_min_y,
        cloudlands_max_y)
end

if core.get_modpath("df_caverns") then

    local lava_min_y =
    tonumber(core.settings:get("dfcaverns_underworld_level")) or -3200

    local lava_max_y =
    tonumber(core.settings:get("dfcaverns_lava_sea_level")) or -2900

    simple_temperature.register_override_zone(
        70,
        0.5,
        lava_min_y,
        lava_max_y)
end
