# Simple Treasures Modpack
Simple Treasures modpack provides containers with randomized loot for Luanti
and minetest game, along with an API to create your own containers and loot
tables. These containers can have different conditions for spawning and also
different treasure pools that can be extended by other mods.

![Screenshot](screenshot.png)

## Requirements
### Mandatory

- [Luanti](https://www.luanti.org/downloads).
- [minetest_game](https://github.com/luanti-org/minetest_game);

## How to use
After installing modpack, containers should spawn in newly generated
mapblocks. 

"Overworld" is a default pack for minetest_game. It provides several tiers of
containers that spawn depending on elevation and other factors. It also
provides integrations for many popular mods, adding items from them into loot
pools.

## Settingtypes
`simple_treasures` provides configuration options, accessible either in Luanti
client settings or by putting configuration options and their values
directly into your `minetest.conf`.

Full list of options, along with their documentation and possible values
is available in this file:
[settingtypes.txt](simple_treasures/settingtypes.txt), located in
`simple_treasures/settingtypes.txt` in this repository.

## Integration with other mods (API)
`simple_treasures` provides these public functions:

```
--------------------------------------------------------------------------------

simple_treasures.register_lootchest(def):

def - table with following fields:

{
    name = "example:example",      - itemstring of the new loot container;
    description = "Example Chest", - description of the new loot container;
    spawn_in = {
        "default:sand",
        "default:desert_sand",
        ...
    },                             - table with one or more nodes to spawn the
                                   - container in;
    spawn_on = {
        "default:stone",
        "default:dirt",
        ...
    },                             - table with one or mode nodes to spawn the
                                     container on;
    sounds = {...},                - same as usual node sounds definition;
    groups = {...},                - same as usual node groups definition;
    y_max = 128,                   - max height for the container to spawn;
    y_min = -128,                  - min height for the container to spawn;
    spawn_in_rarity = 40,          - spawn rarity inside nodes;
    spawn_on_rarity = 2500,        - reverse value for spawn chance on nodes,
                                   - 1 - spawn on every node;
    slot_spawn_chance = 50,        - chance from 0 to 100 to spawn an item
                                   - in each container slot;
    slots = 32,                    - total amount of container slots, max 32.
}

Function registers a new loot chest.

--------------------------------------------------------------------------------

simple_treasures.register_loot_table(chest_name, def):

- chest_name, string, itemstring of a chest for which loot table is registered;
- def, table with following fields:

{
    {"default:apple", 16},      - first element - itemstring, second - max
                                - stack size (random value from 1 up to this);

    {"default:stone_pickaxe"},  - in case with wearable tools, max stack is
                                - always one and the item gets assigned random
                                - wear instead.
    ...
}

Function registers a loot table for a chest.

--------------------------------------------------------------------------------

simple_treasures.merge_loot_tables(chest_name, add_table):

- chest_name, string, itemstring of the container (its loot table);
- add_table, table as described above

Function adds supplied loot table to an already existing one.

--------------------------------------------------------------------------------

simple_treasures.add_to_loot_table(
    chest_name,
    item_string,
    max_stack)

- chest_name, string, itemstring of the container;
- item_strin, string, itemstring of an item to add;
- max_stack, int, max stack size for this loot.

Function adds a single item spawn chance in a loot table.

--------------------------------------------------------------------------------

simple_treasures.get_loot_table(chest_name)

- chest_name, string, itemstring of a chest.

Function returns loot table for a specified chest (or nil if none).

--------------------------------------------------------------------------------
```

## License And Credits
All code and assets in this repository are made by Fruitsnack, unless stated 
or implied otherwise in:

- "License And Credits" section in README (this section);
- Individual file headers;
- Git commit history;
- Merge requests and other means of contribution (i.e. by mailing patches).

Code and text files that are made by Fruitsnack are licensed
under AGPL-3.0-only.  
Full text of the license is available in this file: 
[LICENSE-AGPL-3.0-ONLY](LICENSE-AGPL-3.0-ONLY) in this repository, or, 
alternatively, [here](https://www.gnu.org/licenses/agpl-3.0.en.html).

Assets and media files that are made by Fruitsnack are licensed
under CC-BY-SA-4.0.  
Full text of the license is available in this file: 
[LICENSE-CC-BY-SA-4.0](LICENSE-CC-BY-SA-4.0) in this repository, or, 
alternatively, [here](https://creativecommons.org/licenses/by-sa/4.0/).

`screenshot.png` was made by Fruitsnack using 
[Pixelify-Sans](https://github.com/eifetx/Pixelify-Sans) font by 
Stefie Justprince, licensed under OFL-1.1.  
Full text of the license is available in this file: 
[LICENSE-OFL-1.1](LICENSE-OFL-1.1) in this repository, or, alternatively, 
[here](https://openfontlicense.org/open-font-license-official-text/).

```
    Simple Treasures - Modpack for Luanti and minetest_game that adds
    containers with randomized loot
    Copyright (C) 2025 Fruitsnack

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License version 3 as
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
```

Link to the original source code repository: 
https://codeberg.org/fruitsnack/simple_treasures
