local mod_name = core.get_current_modname()

simple_treasures.register_lootchest({
    name = mod_name .. ":ocean_chest",
    description = "Loot Chest",
    spawn_in = {
        "default:sand",
        "default:desert_sand",
        "default:silver_sand"
    },
    spawn_on = {
        "default:stone"
    },
    sounds = default.node_sound_wood_defaults(),
    groups = {
        choppy = 2,
        oddly_breakable_by_hand = 2
    },
    y_max = 5,
    y_min = -512,
    spawn_in_rarity = 40,
    spawn_on_rarity = 2500,
    slot_spawn_chance = 40,
    slots = 32,
})

simple_treasures.register_lootchest({
    name = mod_name .. ":basket",
    description = "Basket",
    tiles = {
        mod_name .. "_basket_top.png",
        mod_name .. "_basket_top.png",
        mod_name .. "_basket_side.png",
    },
    spawn_on = {
        "default:stone"
    },
    sounds = default.node_sound_wood_defaults(),
    groups = {
        snappy = 2,
        oddly_breakable_by_hand = 2
    },
    y_max = 0,
    y_min = -256,
    spawn_on_rarity = 700,
    slot_spawn_chance = 25,
    slots = 24,
})

simple_treasures.register_lootchest({
    name = mod_name .. ":urn",
    description = "Urn",
    tiles = {
        mod_name .. "_urn_top.png",
        mod_name .. "_urn_top.png",
        mod_name .. "_urn_side.png",
    },
    spawn_on = {
        "default:stone"
    },
    sounds = default.node_sound_stone_defaults(),
    groups = {
        cracky = 2,
        oddly_breakable_by_hand = 2
    },
    y_max = 0,
    y_min = -256,
    spawn_on_rarity = 900,
    slot_spawn_chance = 25,
    slots = 24,
})

simple_treasures.register_lootchest({
    name = mod_name .. ":barrel",
    description = "Barrel",
    tiles = {
        mod_name .. "_barrel_top.png",
        mod_name .. "_barrel_top.png",
        mod_name .. "_barrel_side.png",
    },
    spawn_in = {
        "default:sand",
        "default:desert_sand",
        "default:silver_sand"
    },
    sounds = default.node_sound_wood_defaults(),
    groups = {
        choppy = 2,
        oddly_breakable_by_hand = 2
    },
    y_max = 5,
    y_min = -32,
    spawn_in_rarity = 35,
    slot_spawn_chance = 25,
    slots = 24,
})

simple_treasures.register_lootchest({
    name = mod_name .. ":stone_chest",
    description = "Ancient Chest",
    tiles = {
        mod_name .. "_stone_chest_top.png",
        mod_name .. "_stone_chest_top.png",
        mod_name .. "_stone_chest_side.png",
        mod_name .. "_stone_chest_side.png",
        mod_name .. "_stone_chest_front.png",
    },
    spawn_in = {
        "default:stone"
    },
    spawn_on = {
        "default:stone"
    },
    sounds = default.node_sound_stone_defaults(),
    groups = {
        cracky = 2
    },
    y_max = -128,
    y_min = -4096,
    spawn_in_rarity = 75,
    spawn_on_rarity = 7500,
    slot_spawn_chance = 50,
    slots = 32,
})
