local initial_max_hp = core.settings:get("heartcore_initial_max_hp")

if initial_max_hp == nil then
	initial_max_hp = 10
end

core.register_on_newplayer(function(player)
	player:set_properties({hp_max = initial_max_hp})
	player:set_hp(initial_max_hp)
end)

core.register_on_dieplayer(function(player)
	local name = player:get_player_name()
	local maxHP = player:get_properties().hp_max
	
	if maxHP == 1 then
		core.log("action", name.." lost all his lives and was banned from server")
		core.chat_send_all(name.." lost all his lives and was banned from server")
		player:set_properties({hp_max = 0})
		core.ban_player(name)
	end
end)


core.register_on_respawnplayer(function(player)
	local maxHP = player:get_properties().hp_max
	
	maxHP = maxHP - 1
	player:set_properties({hp_max = maxHP})
	player:set_hp(maxHP)
end)


core.register_on_joinplayer(function(player)
	local maxHP = player:get_properties().hp_max
	
	if maxHP == 0 then
		-- player has probably been unbaned
		player:set_properties({hp_max = initial_max_hp})
		player:set_hp(initial_max_hp)
	end
end)


