local T = fbrawl.T



function fbrawl.is_player_playing(pl_name)
   local arena = arena_lib.get_arena_by_player(pl_name)
   return arena and not arena.in_celebration and not arena.in_loading and not arena.in_queue
end



function fbrawl.out_of_match_operations(pl_name)
   local player = minetest.get_player_by_name(pl_name)

   fbrawl.stop_sounds(pl_name)
   fbrawl.remove_huds(pl_name)

   player:hud_set_hotbar_image("gui_hotbar.png")
   player:hud_set_hotbar_selected_image("gui_hotbar_selected.png")

   arena_lib.HUD_hide("broadcast", pl_name)
   arena_lib.HUD_hide("hotbar", pl_name)

   for skill_name, def in pairs(skills.get_unlocked_skills(pl_name, "fbrawl")) do
      pl_name:remove_skill(skill_name)
   end

   player:set_properties({hp_max = minetest.PLAYER_MAX_HP_DEFAULT})
   player:set_hp(minetest.PLAYER_MAX_HP_DEFAULT)

   panel_lib.get_panel(pl_name, "fbrawl:podium"):hide()
end



function fbrawl.stop_skills(pl_name)
   for skill_name, def in pairs(skills.get_unlocked_skills(pl_name, "fbrawl")) do
      pl_name:stop_skill(skill_name)
   end
end