local function assign_tier() end
local function update_tiers_hud() end



function fbrawl.update_score(arena)
	local scores = {}
	local score_id = 0

	for pl_name, props in pairs(arena.players) do
		local score = props.kills - (props.deaths / 2)
		table.insert(scores, {pl_name = pl_name, score = score, id = score_id})
		score_id = score_id + 1
	end

	table.sort(scores, function (a, b)
		if a.score == b.score then return a.id > b.id end
		return a.score > b.score
	end)

	arena.scores = scores
end



function fbrawl.update_score_hud(pl_name)
	local arena = arena_lib.get_arena_by_player(pl_name)
	update_tiers_hud(pl_name)
end



function update_tiers_hud( pl_name) 
	local arena = arena_lib.get_arena_by_player(pl_name)

	for i, props in pairs(arena.scores) do
		local classified_pl_name = props.pl_name

		if i == 1 then
			assign_tier("golden", pl_name, classified_pl_name)
		elseif i == 2 then
			assign_tier("iron", pl_name, classified_pl_name)
		elseif i == 3 then
			assign_tier("bronze", pl_name, classified_pl_name)
		else
			break
		end
	end
end



function assign_tier(tier, pl_name, classified_pl_name) 
	local panel = panel_lib.get_panel(pl_name, "fbrawl:podium")
	local arena = arena_lib.get_arena_by_player(pl_name)

	panel:update(nil, {
		[tier.."_pl_name"] = {text=classified_pl_name},
		[tier.."_deaths_value"] = {text=arena.players[classified_pl_name].deaths},
		[tier.."_kills_value"] = {text=arena.players[classified_pl_name].kills},
	}, nil)
end