local function get_classes_tabs() end
local function get_skills_tabs() end
local function start_match_if_everyone_selected_a_class() end

local data = {} -- player: ObjectRef = data: table
local T = fbrawl.T



function fbrawl.show_class_selector(pl_name)
	local arena = arena_lib.get_arena_by_player(pl_name)
	
	if not arena or not arena.classes or arena.classes[pl_name] then return end

	data[pl_name] = data[pl_name] or {}
	local pl_data = data[pl_name]

	pl_data.selected_class_name = pl_data.selected_class_name or "Warrior"
	local selected_class = fbrawl.get_class_by_name(pl_data.selected_class_name)

	pl_data.selected_skill_name = pl_data.selected_skill_name or selected_class.skills[1]
	if not fbrawl.class_has_skill(pl_data.selected_class_name, pl_data.selected_skill_name) then
		pl_data.selected_skill_name = selected_class.skills[1]
	end
	local selected_skill = skills.get_skill_def(pl_data.selected_skill_name)

	local formspec =
		"formspec_version[4]"..
		"size[15,15]"..
		"position[0.325,0.18]" ..
		"anchor[0,0]" ..
		"no_prepend[]"..
		"padding[0,0]"..
		"bgcolor[;true]"..
		"style_type[image_button;border=false;size=24;textcolor=#dff6f5;font=mono]"..
		"style_type[image_button;border=false]"..

		-- INFO ABOUT CLASS
		"container[1.3,0]"..
		"image[0,0;9,9.3;fbrawl_gui_selector_bg.png]"..
		"hypertext[1,1;7,1.6;class_name;<global size=32 font=mono color=#472d3c><b>"..T(selected_class.name).."</b>]" ..
		"hypertext[1,2;7,1.6;class_desc;<global size=16 font=mono color=#5e3643>"..selected_class.description.."]" ..
		
		-- SKILLS 
		"container[1,4]"..
		get_skills_tabs(pl_data)..
		"hypertext[0,1.7;7,1.5;class_name;<global size=24 font=mono color=#472d3c><b>"..selected_skill.name.."</b>]" ..
		"hypertext[0,2.4;7,1.8;class_desc;<global size=16 font=mono color=#472d3c>"..selected_skill.description.."]" ..
		"container_end[]" ..
		-- END SKILLS

		"container_end[]" ..
		-- END INFO ABOUT CLASS

		get_classes_tabs(pl_data)..

		-- SELECT BTN
		"image_button_exit[4.2,8.6;2.8,1.3;fbrawl_gui_btn_choose.png;choose_class;Choose]"

	minetest.show_formspec(pl_name, "class_selector", formspec)
end



minetest.register_on_player_receive_fields(function(player, formname, fields)
	if formname ~= "class_selector" then return false end

	local pl_name = player:get_player_name()
	local arena = arena_lib.get_arena_by_player(pl_name)

	-- change the selected class or skill in the formspec
	for skill_or_class, _ in pairs(fields) do
		if string.find(skill_or_class, "unselected_class") then
			data[pl_name].selected_class_name = skill_or_class:split("|")[2]
		elseif string.find(skill_or_class, "unselected_skill") then
			data[pl_name].selected_skill_name = skill_or_class:split("|")[2]
		end
	end


	if fields.choose_class then
		arena.classes[pl_name] = table.copy(fbrawl.get_class_by_name(data[pl_name].selected_class_name))
		
		minetest.sound_play({name="fbrawl_class_selected"}, {to_player = pl_name})
		minetest.chat_send_player(pl_name, T("You've chosen the @1 class", T(data[pl_name].selected_class_name)))

		minetest.close_formspec(pl_name, "class_selector")

		start_match_if_everyone_selected_a_class(arena)

		return
	end

	fbrawl.show_class_selector(pl_name)
end)



minetest.register_craftitem("fantasy_brawl:class_selector", {
   inventory_image = "fbrawl_class_selector_item.png",
   on_drop = function() return end,
	on_use =
      function(itemstack, player)
         fbrawl.show_class_selector(player:get_player_name())
      end
})



function get_classes_tabs(pl_data)
	local btns = ""
	local selected_class_name = pl_data.selected_class_name or "Warrior"

	for i, def in pairs(fbrawl.classes) do
		local class = fbrawl.get_class_by_name(def.name)
		local btn_y = 1.5*(i-1)

		if class.name == selected_class_name then
			btns = btns ..
			"set_focus[selected_class;]"..
			"image_button[0,"..btn_y..";1.5,1.5;fbrawl_gui_btn_class_selected.png;selected_class;]"..
			"image[0,"..btn_y..";1.5,1.5;"..class.icon.."]"

		else
			btns = btns ..
			"image_button[0,"..btn_y..";1.5,1.5;fbrawl_gui_btn_class_unselected.png;unselected_class|"..class.name..";]"..
			"image[0,"..btn_y..";1.5,1.5;"..class.icon.."]"
		end
	end

	return btns
end



function get_skills_tabs(pl_data)
	local btns = ""
	local selected_skill_name = pl_data.selected_skill_name
	local selected_class = fbrawl.get_class_by_name(pl_data.selected_class_name)
	local rendered_btns = 1

	for i, skill_name in pairs(selected_class.skills) do
		local btn_x = 1.90 * (rendered_btns-1)
		local skill = skills.get_skill_def(skill_name)
		local button_type = "fbrawl_gui_btn_skill"

		if rendered_btns == 4 then button_type = "fbrawl_gui_btn_ultimate" end

		if skill.icon then
			if skill_name == selected_skill_name then
				btns = btns ..
				"image_button["..btn_x..",0.02;1.3,1.3;"..button_type.."_selected.png;selected_skill;]"..
				"image["..(btn_x+0.15)..",0.14;1,1;"..skill.icon.."]"

			else
				btns = btns ..
				"image_button["..btn_x..",-0.05;1.3,1.3;"..button_type.."_unselected.png;unselected_skill|"..skill.internal_name..";]"..
				"image["..(btn_x+0.15)..",0.1;1,1;"..skill.icon.."]"
			end

			rendered_btns = rendered_btns + 1
		end
	end
	return btns
end



function fbrawl.start_match_if_everyone_selected_a_class(arena)
	if arena.match_started then return end

	for pl_name, props in pairs(arena.players) do
		if not arena.classes[pl_name] then
			minetest.after(1, function() fbrawl.start_match_if_everyone_selected_a_class(arena) end)
			return 
		end
	end

	local mod_ref = arena_lib.mods["fantasy_brawl"]
	arena_lib.start_arena(mod_ref, arena)
end