local function generate_cloud_particles(self) end
local function play_rain_sound(self) end

local S = fbrawl.T

local cloud_height = 15
local lifetime = 6
local cloud_size = 6
local clouds_grid = 2
local affected_area = cloud_size * clouds_grid * 2

local rain_particles = {
	amount = 50,
	time = 0,
	minpos = vector.new(-cloud_size / 2, -cloud_size / 4, -cloud_size / 2),
	maxpos = vector.new(cloud_size / 2, cloud_size / 4, cloud_size / 2),
	minvel = {x = 0, y = -60, z = 0},
	maxvel = {x = 0, y = -55, z = 0},
	vertical = true,
	minsize = 3,
	maxsize = 6,
	texture = {
		name = "fbrawl_particle_acid_rain.png",
		alpha_tween = {0.5, 1},
	},
	maxexptime = 5,
	collisiondetection = true,
	collision_removal = true,
	object_collision = true,
}
local cloud_particle = {
	amount = 30,
	time = 0,
	minpos = vector.new(-cloud_size / 2, -cloud_size / 4, -cloud_size / 2),
	maxpos = vector.new(cloud_size / 2, cloud_size / 4, cloud_size / 2),
	minvel = {x = -0.5, y = -0.5, z = -0.5},
	maxvel = {x = 0.5, y = 0.5, z = 0.5},
	minsize = 55,
	maxsize = 60,
	texture = {
		name = "fbrawl_acid_cloud.png",
		alpha_tween = {1, 0},
		scale_tween = {
			{x = 0.9, y = 0.9},
			{x = 1,   y = 1},
		}
	},
	minexptime = 1,
	maxexptime = 1.5,
}





--
-- SKILL SECTION
--

skills.register_skill_based_on({"fbrawl:ulti_layer"}, "fbrawl:pestilential_deluge", {
	name = S("Pestilential Deluge"),
	description = S("Summons clouds around the player that rain down acidic puddles, damaging any players caught in them and healing you."),
	icon = "fbrawl_pestilential_deluge_skill.png",
	sounds = {cast = {name = "fbrawl_thunder", max_hear_distance = affected_area}},
	cooldown = lifetime,
	cast = function(self)
		play_rain_sound(self)
		local player_pos = self.player:get_pos()
		local ray_origin = vector.add(player_pos, {x = 0, y = 1.5, z = 0})
		local min_cloud_height_offset = 3

		-- Determine shared y for all clouds by raycasting up from player eyes
		local shared_cloud_y = player_pos.y + cloud_height
		do
			local up_dir = {x = 0, y = 1, z = 0}
			local up_range = cloud_height
			local ray = fbrawl.raycast(ray_origin, up_dir, up_range, false)
			local pointed_thing = ray:next()
			if pointed_thing and pointed_thing.type == "node" and pointed_thing.under then
				local hit_y = pointed_thing.under.y - 1
				if hit_y >= ray_origin.y + min_cloud_height_offset then
					shared_cloud_y = hit_y
				else
					shared_cloud_y = ray_origin.y + min_cloud_height_offset
				end
			end
		end

		for x = -clouds_grid, clouds_grid do
			for z = -clouds_grid, clouds_grid do
				local target_pos = {
					x = player_pos.x + x * cloud_size + fbrawl.random(-cloud_size / 4, cloud_size / 4),
					y = shared_cloud_y,
					z = player_pos.z + z * cloud_size + fbrawl.random(-cloud_size / 4, cloud_size / 4)
				}
				core.add_entity(target_pos, "fantasy_brawl:acid_cloud", self.pl_name)
			end
		end
	end
})





--
-- ENTITY SECTION
--

local cloud_def = {
	initial_properties = {
		hp_max = 20,
		physical = false,
		collide_with_objects = false,
		visual = "sprite",
		textures = {"fbrawl_transparent.png"},
		pointable = false,
		static_save = false,
	},
	pl_name = "",
	time_passed = 0,
	rain_particles = -1
}



function cloud_def:on_activate(staticdata)
	if not staticdata or not core.get_player_by_name(staticdata) then
		self.object:remove()
		return
	end
	self.pl_name = staticdata

	generate_cloud_particles(self)
end



function cloud_def:on_step(dtime)
	self.time_passed = self.time_passed + dtime

	if self.time_passed >= lifetime - 0.5 then
		core.delete_particlespawner(self.rain_particles)
	end

	if self.time_passed >= lifetime then
		self.object:remove()
		return
	end
end



core.register_entity("fantasy_brawl:acid_cloud", cloud_def)





--
-- LOCAL FUNCTIONS
--

-- Only these two variables control puddle spawning:
local puddle_size = 6 -- size of each puddle
local puddle_grid = 2 -- number of puddles per cloud side (puddle_grid x puddle_grid)

function generate_cloud_particles(self)
	local cloud_particles = table.copy(cloud_particle)
	local rain_particles = table.copy(rain_particles)
	cloud_particles.attached = self.object
	rain_particles.attached = self.object

	core.add_particlespawner(cloud_particles)
	core.after(0.5, function()
		if not core.get_player_by_name(self.pl_name) then return end

		self.rain_particles = core.add_particlespawner(rain_particles)

		local cloud_pos = self.object:get_pos()
		local total_grid = puddle_grid
		local area_size = cloud_size
		local step = 3

		for ix = 0, total_grid - 1 do
			for iz = 0, total_grid - 1 do
				local offset_x = -area_size / 2 + (puddle_size / 2) + ix * step
				local offset_z = -area_size / 2 + (puddle_size / 2) + iz * step
				local puddle_pos = vector.add(cloud_pos, {x = offset_x, y = 0, z = offset_z})
				local ground_pos, found_ground = fbrawl.get_lowest_terrain_point(puddle_pos, cloud_height + 4, 1, 1)
				if found_ground then
					local final_spawn_pos = vector.add(ground_pos, {x = 0, y = 0.05, z = 0})
					local node_below = core.get_node_or_nil(vector.subtract(ground_pos, vector.new(0, 0.5, 0)))
					if node_below and node_below.name and node_below.name:find("slab") then
						final_spawn_pos.y = final_spawn_pos.y - 0.5
					end
					core.add_entity(final_spawn_pos, "fantasy_brawl:acid_puddle", core.serialize({self.pl_name, puddle_size, lifetime, true, self.pl_name .. ":deluge"}))
				end
			end
		end
	end)
end



function play_rain_sound(self)
	local rain_sound = core.sound_play({name = "fbrawl_rain"}, {
		pos = self.player:get_pos(),
		max_hear_distance = affected_area,
		fade = 0.1
	})
	core.after(lifetime - 1.5, function()
		core.sound_fade(rain_sound, 0.1, 0)
	end)
end
