--- FIFO queue with de-duplication.

--#region types
---@class FifoSet
---@field set table<any, boolean>
---@field list any[]
---@field head integer
---@field tail integer
---@field push fun(self: FifoSet, key: any): boolean
---@field pop fun(self: FifoSet): any|nil
---@field len fun(self: FifoSet): integer
---@field clear fun(self: FifoSet)
--#endregion

local FifoSet = {}
FifoSet.__index = FifoSet



---@return FifoSet
function FifoSet.new()
	return setmetatable({
		set = {},
		list = {},
		head = 1,
		tail = 0,
	}, FifoSet)
end



---@param key any
---@return boolean
function FifoSet:push(key)
	if self.set[key] then
		return false
	end
	self.set[key] = true
	self.tail = self.tail + 1
	self.list[self.tail] = key
	return true
end



---@return any|nil
function FifoSet:pop()
	local i = self.head
	local tail = self.tail
	local list = self.list
	while i <= tail do
		local key = list[i]
		list[i] = nil
		i = i + 1
		if key and self.set[key] then
			self.set[key] = nil
			self.head = i
			return key
		end
	end

	self.list = {}
	self.head = 1
	self.tail = 0
	return nil
end



---@return integer
function FifoSet:len()
	return math.max(0, (self.tail - self.head + 1))
end



function FifoSet:clear()
	self.set = {}
	self.list = {}
	self.head = 1
	self.tail = 0
end



map_octree.FifoSet = FifoSet
