local testutil = dofile(core.get_modpath("map_octree") .. "/src/tests/util.lua")

---@diagnostic disable: undefined-field

-- Async tests cannot block - results are logged via core.after callbacks
local async_results = {}


map_octree.tests.register("OctreeManip: apply_async works with non-centered bounds", function(ctx)
	assert(ctx and ctx.player, "ctx.player required")
	if map_octree.tests.async_should_skip and map_octree.tests.async_should_skip("apply_async_noncenter") then
		return
	end
	local oc = octchunk

	local pos0 = testutil.get_test_region(ctx.player)
	local center = vector.add(oc.snap_to_center(pos0), {x = 0, y = 0, z = 7680})
	local half = oc.SIZE / 2
	local pmin = vector.subtract(center, {x = half, y = half, z = half})
	local pmax = vector.add(center, {x = half - 1, y = half - 1, z = half - 1})

	-- Deliberately use non-centered corners (like WorldEdit selections)
	local q1 = vector.add(pmin, {x = 1, y = 2, z = 3})
	local q2 = vector.subtract(pmax, {x = 1, y = 1, z = 1})

	local cid_a = core.get_content_id("default:stone")
	local cid_b = core.get_content_id("default:dirt")
	assert(type(cid_a) == "number", "missing node: default:stone")
	assert(type(cid_b) == "number", "missing node: default:dirt")

	local test_id = "octree_apply_async_noncenter_" .. os.time()
	async_results[test_id] = {status = "pending", start = core.get_us_time()}
	local end_async = nil
	if map_octree.tests.async_start then
		end_async = map_octree.tests.async_start(test_id)
	end

	testutil.with_voxel_region(pmin, pmax, function(manip, area, data, param2_data)
		-- Fill entire region with stone
		for x = pmin.x, pmax.x do
			for y = pmin.y, pmax.y do
				for z = pmin.z, pmax.z do
					data[area:index(x, y, z)] = cid_a
				end
			end
		end
		manip:set_data(data)
		for i = 1, #param2_data do
			param2_data[i] = 0
		end
		manip:set_param2_data(param2_data)
		manip:write_to_map(false)

		local m = map_octree.new_octree_manip()
		m:read_from_map(q1, q2)

		m:apply_async(q1, q2, function(_, _, _, cid, p2)
			if cid == cid_a then
				return cid_b, p2
			end
			return
		end, function(ok, changed, err)
			local res = async_results[test_id]
			if not ok then
				res.status = "FAIL"
				res.error = tostring(err)
				core.log("error", "[test] " .. test_id .. ": " .. res.error)
				if end_async then end_async() end
				return
			end
			if (changed or 0) <= 0 then
				res.status = "FAIL"
				res.error = "expected some changes"
				core.log("error", "[test] " .. test_id .. ": " .. res.error)
				if end_async then end_async() end
				return
			end

			m:write_to_map_async(function(wok, werr)
				if not wok then
					res.status = "FAIL"
					res.error = tostring(werr)
					core.log("error", "[test] " .. test_id .. ": write failed: " .. res.error)
					if end_async then end_async() end
					return
				end

				-- Verify changed node via VoxelManip readback
				core.load_area(pmin, pmax)
				local vm = core.get_voxel_manip()
				local e1, e2 = vm:read_from_map(pmin, pmax)
				local va = VoxelArea(e1, e2)
				local out = {}
				vm:get_data(out)
				if vm.close then vm:close() end

				local idx = va:index(q1.x, q1.y, q1.z)
				if out[idx] ~= cid_b then
					res.status = "FAIL"
					res.error = "live mismatch after apply_async"
					core.log("error", "[test] " .. test_id .. ": " .. res.error)
					if end_async then end_async() end
					return
				end

				res.status = "PASS"
				local elapsed_ms = (core.get_us_time() - res.start) / 1000
				core.log("action", string.format("[test] %s: PASS (changed=%d) - %.1fms", test_id, tonumber(changed) or -1, elapsed_ms))
				if end_async then end_async() end
			end)
		end)

		core.log("action", "[test] " .. test_id .. ": async operation started (result will be logged)")
	end)
end)