map_octree.tests.register("octmap: remaps content_ids on tree deserialize", function()
	local node_a = "default:stone"
	local cid_real = core.get_content_id(node_a)
	assert(type(cid_real) == "number", "missing node: " .. node_a)

	-- Pick a synthetic (old) content_id that should not exist in this session.
	local cid_old = cid_real + 1000000

	local center = octchunk.snap_to_center({x = 0, y = 0, z = 0})
	local tree = {
		center = center,
		size = octchunk.SIZE,
		[octchunk.ID] = cid_old,
	}
	local blob = octchunk.serialize(tree)

	local map = {
		minp = center,
		maxp = center,
		default_node = "air",
		cache_mb = 1,
		content_id_map = {
			[cid_old] = node_a,
		},
		trees = matrix3d.new(1, 1, 1, blob),
	}
	octmap.attach_methods(map)

	local got = select(1, map:get_node_at(center.x, center.y, center.z))
	assert(got == node_a, "expected remapped node name")
end)

map_octree.tests.register("octmap: handles missing nodes as CONTENT_IGNORE", function()
	local node_missing = "nonexistent_mod:missing_node"
	local cid_old = 999999

	local center = octchunk.snap_to_center({x = 0, y = 0, z = 0})
	local tree = {
		center = center,
		size = octchunk.SIZE,
		[octchunk.ID] = cid_old,
	}
	local blob = octchunk.serialize(tree)

	local map = {
		minp = center,
		maxp = center,
		default_node = "air",
		cache_mb = 1,
		content_id_map = {
			[cid_old] = node_missing,
		},
		trees = matrix3d.new(1, 1, 1, blob),
	}
	octmap.attach_methods(map)

	-- Should not crash, should return "ignore" for missing node
	local got = select(1, map:get_node_at(center.x, center.y, center.z))
	assert(got == "ignore", "expected 'ignore' for missing node, got: " .. tostring(got))
end)