local testutil = dofile(core.get_modpath("map_octree") .. "/src/tests/util.lua")

---@diagnostic disable: undefined-field


map_octree.tests.register("OctreeManip: works with non-centered bounds", function(ctx)
	assert(ctx and ctx.player, "ctx.player required")

	local pos0 = testutil.get_test_region(ctx.player)
	local center = vector.add(octchunk.snap_to_center(pos0), {x = 0, y = 0, z = 7168})
	local half = octchunk.SIZE / 2
	local pmin = vector.subtract(center, {x = half, y = half, z = half})
	local pmax = vector.add(center, {x = half - 1, y = half - 1, z = half - 1})

	-- Deliberately pass non-centered corners to read_from_map (like WorldEdit does)
	local q1 = vector.add(pmin, {x = 1, y = 2, z = 3})
	local q2 = vector.subtract(pmax, {x = 1, y = 1, z = 1})

	local cid_a = core.get_content_id("default:stone")
	local cid_b = core.get_content_id("default:dirt")
	assert(type(cid_a) == "number", "missing node: default:stone")
	assert(type(cid_b) == "number", "missing node: default:dirt")

	testutil.with_voxel_region(pmin, pmax, function(manip, area, data, param2_data)
		for x = pmin.x, pmax.x do
			for y = pmin.y, pmax.y do
				for z = pmin.z, pmax.z do
					data[area:index(x, y, z)] = cid_a
				end
			end
		end
		manip:set_data(data)
		for i = 1, #param2_data do
			param2_data[i] = 0
		end
		manip:set_param2_data(param2_data)
		manip:write_to_map(false)

		local m = map_octree.new_octree_manip()
		m:read_from_map(q1, q2)
		local changed = m:apply(q1, q2, function(_, _, _, cid, p2)
			if cid == cid_a then
				return cid_b, p2
			end
			return
		end)
		assert(changed > 0, "expected some changes")
		assert(m:write_to_map(), "write_to_map failed")

		local map = octmap.new(pmin, pmax, {store_chunk_blobs = true, force_batches = true})
		local got, _ = map:get_node_cid_at(q1.x, q1.y, q1.z)
		assert(got == cid_b, "expected dirt after apply")
	end)
end)