map_octree.tests.register("serialization: invalid header/corruption", function(ctx)
	assert(ctx and ctx.player, "ctx.player required")
	local pos = assert(ctx.player:get_pos(), "player position required")
	local p_round = assert(vector.round(pos), "player position required")
	local center = octchunk.snap_to_center(p_round)

	local map = octmap.new(center, center, {
		max_voxelmanip_volume = (octchunk.SIZE + 1) ^ 3 * 2,
		force_batches = true,
	})

	local blob, err = octmap.serialize(map)
	assert(blob, err or "serialize failed")

	local map_bad, err_bad = octmap.deserialize("bad")
	assert(map_bad == nil and err_bad, "expected invalid header failure")

	local magic = blob:sub(1, 5)
	local map_corrupt, err_corrupt = octmap.deserialize(magic .. "x")
	assert(map_corrupt == nil and err_corrupt, "expected corrupt payload failure")

	local dir = map_octree.get_storage_dir()
	local name = "bad_header_" .. tostring(os.time())
	local path = dir .. "/" .. name .. ".bin"
	core.safe_file_write(path, "bad")

	local loaded = map_octree.load_map(name)
	assert(loaded == nil, "expected load_map to fail on invalid header")
	os.remove(path)
end)
