--- Octree-based map snapshot and restoration.
-- Provides efficient memory-limited snapshots of Luanti map regions using octree compression.
-- Handles batched VoxelManip reads, sparse storage, and async operations.

--#region types
---@class OctreeCacheLruNode
---@field prev? integer
---@field next? integer

---@class OctreeCacheLru
---@field head? integer
---@field tail? integer
---@field nodes? table<integer, OctreeCacheLruNode>

---@class OctMap
---@field minp vector Snapped minimum corner
---@field maxp vector Snapped maximum corner
---@field requested_pos1? vector Original requested min corner
---@field requested_pos2? vector Original requested max corner
---@field default_node? string Node name for sparse cells
---@field default_content_id? integer Content ID for sparse cells
---@field content_id_map table<integer, string> Content ID to name mapping
---@field trees Matrix3D Grid of Octchunk or compressed blobs
---@field cache_mb? number LRU cache size limit in MB
---@field get_node_at fun(self: OctMap, x: number, y: number, z: number): string|nil, integer, integer
---@field get_node_cid_at fun(self: OctMap, x: number, y: number, z: number): integer|nil, integer, integer
---@field for_each_node fun(self: OctMap, pos1: vector, pos2: vector, cb: fun(x: number, y: number, z: number, name: string, param2: integer, param1: integer)): integer
---@field for_each_node_cid fun(self: OctMap, pos1: vector, pos2: vector, cb: fun(x: number, y: number, z: number, content_id: integer, param2: integer, param1: integer)): integer
---@field read_ranges fun(self: OctMap, ranges: OctreeRange[], cb: fun(x: number, y: number, z: number, content_id: integer, param2: integer, param1: integer), opts?: RangeIterateOpts): integer
---@field for_each_chunk_range fun(self: OctMap, ranges: OctreeRange[], cb: fun(chunk_min: vector, chunk_max: vector, gx: integer, gy: integer, gz: integer, tree: Octchunk|nil, is_sparse: boolean), opts?: RangeIterateOpts): integer
---@field get_emerged_area fun(self: OctMap): vector|nil, vector|nil
---@field size fun(self: OctMap): vector
---@field enable_tracking fun(self: OctMap)
---@field disable_tracking fun(self: OctMap, opts?: RestoreDisableOpts)
---@field flush_tracking fun(self: OctMap, opts?: RestoreFlushOpts): RestoreFlushResult|nil
---@field get_tracking_status fun(self: OctMap): RestoreTrackingStatus|nil
---@field restore fun(self: OctMap, opts?: RestoreOptions): boolean, string?
---@field schedule_restore fun(self: OctMap, callback: fun(ok: boolean, err?: string))
---@field is_restoring fun(self: OctMap): boolean
---@field get_restore_state fun(self: OctMap): RestoreStateInfo|nil
---@field _enqueue_chunk_for_verification fun(self: OctMap, gx: integer, gy: integer, gz: integer)
---@field _verify_chunk_now fun(self: OctMap, gx: integer, gy: integer, gz: integer)
---@field _pop_pending_key_for_tests fun(self: OctMap): integer|nil
---@field _pending_count_for_tests fun(self: OctMap): integer
---@field _tree_cache? table<integer, Octchunk> Internal: decompressed tree cache
---@field _tree_cache_lru? OctreeCacheLru Internal: LRU tracking
---@field _tree_cache_bytes? table<integer, integer> Internal: per-tree memory tracking
---@field _cache_total_bytes? integer Internal: total cache memory usage
---@field _cache_peak_bytes? integer Internal: peak cache memory usage
---@field _cache_evictions? integer Internal: cache eviction counter
---@field _cid_remap? table<integer, integer> Internal: content_id remapping cache
---@field _tracker_id? integer Internal: restore tracking ID (if tracking enabled)

---@class MapCreationOpts
---@field cache_mb? number
---@field max_voxelmanip_volume? integer
---@field store_chunk_blobs? boolean
---@field force_batches? boolean
---@field choose_batch_chunk_sizes? fun(total_x: integer, total_y: integer, total_z: integer, max_voxelmanip_volume: integer): integer, integer, integer
---@field _octmap_limits_applied? boolean
---@field _octmap_vm_arrays? integer
---@field _octmap_gc_limit_kb? integer
--#endregion

octmap = {}
