local rt = map_octree.restore_tracking
local MAPBLOCK_SIZE = rt.MAPBLOCK_SIZE



---@param tracker RestoreTracker
---@param gx integer
---@param gy integer
---@param gz integer
function rt.write_chunk_to_world(tracker, gx, gy, gz)
	local map = tracker.map
	local node_min = rt.grid_to_node_min(tracker, gx, gy, gz)
	local node_max = {
		x = node_min.x + MAPBLOCK_SIZE - 1,
		y = node_min.y + MAPBLOCK_SIZE - 1,
		z = node_min.z + MAPBLOCK_SIZE - 1,
	}

	core.load_area(node_min, node_max)
	local manip = core.get_voxel_manip()
	local e1, e2 = manip:read_from_map(node_min, node_max)
	local area = VoxelArea(e1, e2)
	local volume = (e2.x - e1.x + 1) * (e2.y - e1.y + 1) * (e2.z - e1.z + 1)

	local default_cid = core.get_content_id(map.default_node or "air")
	local data = tracker._write.data
	local p2 = tracker._write.param2
	local p1 = tracker._write.param1
	for i = 1, volume do
		data[i] = default_cid
		p2[i] = 0
		p1[i] = 0
	end

	local cell = matrix3d.get(map.trees, gx, gy, gz)
	if cell ~= nil then
		local tree = assert(octmap._get_tree_cached(map, gx, gy, gz))
		local half = octchunk.SIZE / 2
		local center = vector.new(node_min.x + half, node_min.y + half, node_min.z + half)
		octchunk.fill_voxel_area(tree, node_min, node_max, area, data, p2, p1, nil, center, tree.size or octchunk.SIZE)
	end

	manip:set_data(data)
	manip:set_param2_data(p2)
	manip:set_light_data(p1)
	manip:write_to_map(true)
	manip:close()
end
