local testutil = dofile(core.get_modpath("map_octree") .. "/src/tests/util.lua")

---@diagnostic disable: undefined-field


map_octree.tests.register("OctreeManip: apply_async mirrors apply semantics", function(ctx)
	assert(ctx and ctx.player, "ctx.player required")
	if map_octree.tests.async_should_skip and map_octree.tests.async_should_skip("apply_async") then
		return
	end
	local oc = octchunk

	local origin = testutil.get_test_region(ctx.player)
	local size = 16
	local nsize = tonumber(oc.SIZE)
	if nsize then
		size = math.floor(nsize)
	end
	local base = vector.add(oc.snap_to_center(origin), {x = 0, y = 0, z = 9216})
	local half = size / 2
	local pmin = vector.subtract(base, {x = half, y = half, z = half})
	local pmax = vector.add(base, {x = half - 1, y = half - 1, z = half - 1})

	local node_stone = "default:stone"
	local node_dirt = "default:dirt"
	local node_sand = "default:sand"
	local c_stone = core.get_content_id(node_stone)
	local c_dirt = core.get_content_id(node_dirt)
	local c_sand = core.get_content_id(node_sand)
	assert(type(c_stone) == "number", "missing node: " .. node_stone)
	assert(type(c_dirt) == "number", "missing node: " .. node_dirt)
	assert(type(c_sand) == "number", "missing node: " .. node_sand)

	local sub1 = {x = pmin.x, y = pmin.y, z = pmin.z}
	local sub2 = {x = pmin.x + 3, y = pmin.y + 3, z = pmin.z + 3}
	local sub_volume = (sub2.x - sub1.x + 1) * (sub2.y - sub1.y + 1) * (sub2.z - sub1.z + 1)
	local volume = size * size * size
	local test_id = "apply_async_" .. os.time()
	local end_async = nil
	if map_octree.tests.async_start then
		end_async = map_octree.tests.async_start(test_id)
	end

	testutil.with_voxel_region_async(pmin, pmax, function(manip, area, data, param2_data, restore)
		for x = pmin.x, pmax.x do
			for y = pmin.y, pmax.y do
				for z = pmin.z, pmax.z do
					data[area:index(x, y, z)] = c_stone
				end
			end
		end
		for x = sub1.x, sub2.x do
			for y = sub1.y, sub2.y do
				for z = sub1.z, sub2.z do
					data[area:index(x, y, z)] = c_dirt
				end
			end
		end

		for i = 1, #param2_data do
			param2_data[i] = 0
		end
		manip:set_data(data)
		manip:set_param2_data(param2_data)
		manip:write_to_map(false)

		local m = map_octree.new_octree_manip()
		m:read_from_map(pmin, pmax)

		local function fail(msg)
			core.log("error", "[test] " .. test_id .. ": FAIL - " .. tostring(msg))
			if end_async then end_async() end
			restore()
		end

		local function pass()
			core.log("action", "[test] " .. test_id .. ": PASS")
			if end_async then end_async() end
			restore()
		end

		local function do_set()
			m:read_from_map(pmin, pmax)
			m:apply_async(pmin, pmax, function(_, _, _, cid, p2)
				if cid == c_dirt then
					return
				end
				return c_dirt, p2
			end, function(ok, changed)
				core.after(0, function()
					if not ok then
						fail("apply_async set failed")
						return
					end
					if changed ~= (volume - sub_volume) then
						fail("set changed_count mismatch")
						return
					end
					if not m:write_to_map() then
						fail("write_to_map failed")
						return
					end
					if testutil.count_cid_in_snapshot(pmin, pmax, c_dirt, size) ~= volume then
						fail("set dirt count mismatch")
						return
					end
					pass()
				end)
			end)
		end

		m:apply_async(pmin, pmax, function(_, _, _, cid, p2)
			if cid == c_stone then
				return c_sand, p2
			end
			return
		end, function(ok, changed)
			core.after(0, function()
				if not ok then
					fail("apply_async replace failed")
					return
				end
				if changed ~= (volume - sub_volume) then
					fail("replace changed_count mismatch")
					return
				end
				if not m:write_to_map() then
					fail("write_to_map failed")
					return
				end
				if testutil.count_cid_in_snapshot(pmin, pmax, c_sand, size) ~= (volume - sub_volume) then
					fail("replace sand count mismatch")
					return
				end
				if testutil.count_cid_in_snapshot(pmin, pmax, c_dirt, size) ~= sub_volume then
					fail("replace dirt count mismatch")
					return
				end
				do_set()
			end)
		end)
	end)
end)
