local testutil = dofile(core.get_modpath("map_octree") .. "/src/tests/util.lua")

---@diagnostic disable: undefined-field

-- Async tests cannot block - results are logged via callbacks
local async_results = {}


map_octree.tests.register("OctreeManip: apply_async can update param1 in snapshot", function(ctx)
	assert(ctx and ctx.player, "ctx.player required")
	if map_octree.tests.async_should_skip and map_octree.tests.async_should_skip("apply_async_param1") then
		return
	end

	local pos0 = testutil.get_test_region(ctx.player)
	local base = vector.add(octchunk.snap_to_center(pos0), {x = 0, y = 0, z = 8192})
	local half = octchunk.SIZE / 2
	local pmin = vector.subtract(base, {x = half, y = half, z = half})
	local pmax = vector.add(base, {x = half - 1, y = half - 1, z = half - 1})

	local cid_air = core.get_content_id("air")
	assert(type(cid_air) == "number", "missing node: air")

	local target = vector.add(pmin, {x = 2, y = 2, z = 2})

	local test_id = "octree_apply_async_param1_" .. os.time()
	async_results[test_id] = {status = "pending", start = core.get_us_time()}
	local end_async = nil
	if map_octree.tests.async_start then
		end_async = map_octree.tests.async_start(test_id)
	end

	testutil.with_voxel_region(pmin, pmax, function(manip, area, data, param2_data)
		-- Ensure we start from a known state.
		for z = pmin.z, pmax.z do
			for y = pmin.y, pmax.y do
				for x = pmin.x, pmax.x do
					local idx = area:index(x, y, z)
					data[idx] = cid_air
					if param2_data then
						param2_data[idx] = 0
					end
				end
			end
		end
		manip:set_data(data)
		if manip.set_param2_data and param2_data then
			manip:set_param2_data(param2_data)
		end
		manip:write_to_map(false)

		local m = map_octree.new_octree_manip()
		m:read_from_map(pmin, pmax)

		local _, p2_before, p1_before = m:get_node_at(target.x, target.y, target.z)
		assert(p1_before ~= nil, "expected param1 to be present in snapshot")
		assert(p2_before ~= nil, "expected param2 to be present in snapshot")
		local p1_after = (tonumber(p1_before) + 9) % 256
		local cid_stone = core.get_content_id("default:stone")
		assert(type(cid_stone) == "number", "missing node: default:stone")

		local function fail_async(res, err)
			res.status = "FAIL"
			res.error = tostring(err)
			core.log("error", "[test] " .. test_id .. ": " .. res.error)
			if end_async then end_async() end
		end

		local function apply_update_param1()
			m:apply_async(target, target, function(_, _, _, cid, p2, p1)
				assert(p1 == p1_before, "apply_async callback param1 mismatch")
				return cid, p2, p1_after
			end, function(ok, changed, err)
				local res = async_results[test_id]
				if not ok then
					fail_async(res, err)
					return
				end

				local _, _, got_p1 = m:get_node_at(target.x, target.y, target.z)
				if got_p1 ~= p1_after then
					fail_async(res, string.format("snapshot param1 mismatch: expected %d, got %d", p1_after, tonumber(got_p1) or -1))
					return
				end

				-- Ensure the write pipeline doesn't error with param1-bearing deltas.
				m:write_to_map_async(function(wok, werr)
					if not wok then
						fail_async(res, "write failed: " .. tostring(werr))
						return
					end

					res.status = "PASS"
					local elapsed_ms = (core.get_us_time() - res.start) / 1000
					core.log("action", string.format("[test] %s: PASS (changed=%d) - %.1fms", test_id, tonumber(changed) or -1, elapsed_ms))
					if end_async then end_async() end
				end)
			end)
		end

		m:apply_async(target, target, function(_, _, _, _, _, _)
			return cid_stone
		end, function(ok, _, err)
			local res = async_results[test_id]
			if not ok then
				fail_async(res, err)
				return
			end

			local _, got_p2, got_p1 = m:get_node_at(target.x, target.y, target.z)
			if got_p2 ~= p2_before then
				fail_async(res, "param2 should stay unchanged when omitted")
				return
			end
			if got_p1 ~= p1_before then
				fail_async(res, "param1 should stay unchanged when omitted")
				return
			end

			apply_update_param1()
		end)

		core.log("action", "[test] " .. test_id .. ": async operation started (result will be logged)")
	end)
end)