local testutil = dofile(core.get_modpath("map_octree") .. "/src/tests/util.lua")

---@diagnostic disable: undefined-field


map_octree.tests.register("OctreeManip: apply can update param1 in snapshot", function(ctx)
	assert(ctx and ctx.player, "ctx.player required")

	local pos0 = testutil.get_test_region(ctx.player)
	local base = vector.add(octchunk.snap_to_center(pos0), {x = 0, y = 0, z = 7168})
	local half = octchunk.SIZE / 2
	local pmin = vector.subtract(base, {x = half, y = half, z = half})
	local pmax = vector.add(base, {x = half - 1, y = half - 1, z = half - 1})

	local cid_air = core.get_content_id("air")
	assert(type(cid_air) == "number", "missing node: air")

	local target = vector.add(pmin, {x = 2, y = 2, z = 2})

	testutil.with_voxel_region(pmin, pmax, function(manip, area, data, param2_data)
		-- Ensure we start from a known state.
		for z = pmin.z, pmax.z do
			for y = pmin.y, pmax.y do
				for x = pmin.x, pmax.x do
					local idx = area:index(x, y, z)
					data[idx] = cid_air
					if param2_data then
						param2_data[idx] = 0
					end
				end
			end
		end
		manip:set_data(data)
		if manip.set_param2_data and param2_data then
			manip:set_param2_data(param2_data)
		end
		manip:write_to_map(false)

		local m = map_octree.new_octree_manip()
		m:read_from_map(pmin, pmax)

		local _, p2_before, p1_before = m:get_node_at(target.x, target.y, target.z)
		assert(p1_before ~= nil, "expected param1 to be present in snapshot")
		assert(p2_before ~= nil, "expected param2 to be present in snapshot")

		local cid_stone = core.get_content_id("default:stone")
		assert(type(cid_stone) == "number", "missing node: default:stone")

		local changed_default_params = m:apply(target, target, function(_, _, _, _, _, _)
			return cid_stone
		end)
		assert(changed_default_params == 1, "apply changed_count mismatch (default params)")

		local _, got_p2_default, got_p1_default = m:get_node_at(target.x, target.y, target.z)
		assert(got_p2_default == p2_before, "param2 should stay unchanged when omitted")
		assert(got_p1_default == p1_before, "param1 should stay unchanged when omitted")

		local p1_after = (tonumber(p1_before) + 7) % 256
		assert(p1_after ~= p1_before, "test requires a param1 change")

		local changed = m:apply(target, target, function(_, _, _, cid, p2, p1)
			assert(p1 == p1_before, "apply callback param1 mismatch")
			return cid, p2, p1_after
		end)
		assert(changed == 1, "apply changed_count mismatch")

		local _, _, got_p1 = m:get_node_at(target.x, target.y, target.z)
		assert(got_p1 == p1_after, string.format("snapshot param1 mismatch: expected %d, got %d", p1_after, tonumber(got_p1) or -1))

		-- Not asserting live param1 because write_to_map(true) updates lighting.
		assert(m:write_to_map(), "write_to_map failed")
	end)
end)