map_octree.tests.register("batch planner: edge geometry", function()
	local function assert_true(cond, msg)
		if not cond then error(msg or "assert failed") end
	end

	local function check(minp, maxp)
		local plan = octmap.plan_batches(minp, maxp, {
			max_voxelmanip_volume = (octchunk.SIZE + 1) ^ 3 * 2,
			force_batches = true,
		})
		assert_true(#plan.batches >= 1, "no batches")
		for _, b in ipairs(plan.batches) do
			assert_true(b.volume <= plan.max_voxelmanip_volume, "batch exceeds volume")
		end

		-- coverage check: ensure every (x,y,z) index is covered exactly once
		local size = plan.size
		local seen = {}
		local function key(x, y, z)
			return x .. ":" .. y .. ":" .. z
		end
		for _, b in ipairs(plan.batches) do
			for x = b.x_idx, b.x_end do
				for y = b.y_idx, b.y_end do
					for z = b.z_idx, b.z_end do
						local k = key(x, y, z)
						if seen[k] then error("overlap at " .. k) end
						seen[k] = true
					end
				end
			end
		end
		for x = 1, size.x do
			for y = 1, size.y do
				for z = 1, size.z do
					assert_true(seen[key(x, y, z)], string.format("gap at %d,%d,%d", x, y, z))
				end
			end
		end
	end

	-- negative coords + unsorted
	check(vector.new(-100, -200, -300), vector.new(-400, -50, -10))
	-- thin area 1xN x1 (not aligned)
	check(vector.new(13, 7, 19), vector.new(13, 7 + 64 * 5 + 3, 19))
	-- boundary exact on chunk edge (should still snap)
	check(vector.new(0, 0, 0), vector.new(64, 64, 64))
	-- skinny in X, wide in Z, negative mixed
	check(vector.new(-5, 0, -999), vector.new(5, 64 * 2 + 1, -999 + 64 * 7 + 2))
end)