map_octree.tests.register("bounds + file I/O", function(ctx)
	assert(ctx and ctx.player, "ctx.player required")
	local pos = vector.round(ctx.player:get_pos())
	local center = octchunk.snap_to_center(pos)

	local map = octmap.new(center, center, {
		max_voxelmanip_volume = (octchunk.SIZE + 1) ^ 3 * 2,
		force_batches = true,
	})

	local outside = vector.add(center, { x = 64 * 10, y = 0, z = 0 })
	local got = octmap.get_node_name(map, outside)
	if got ~= nil then
		error("expected nil outside bounds")
	end

	local testfile = core.get_worldpath() .. "/octree_map_test.bin"
	local blob, err = octmap.serialize(map)
	assert(blob, err or "serialize failed")
	core.safe_file_write(testfile, blob)

	local loaded, err_load = octmap.read_from_file(testfile)
	assert(type(loaded) == "table", err_load or "expected loaded map")

	os.remove(testfile)

	-- spot check a few positions
	local positions = {
		center,
		vector.subtract(center, { x = 32, y = 32, z = 32 }),
		vector.add(center, { x = 31, y = 31, z = 31 }),
	}
	for _, p in ipairs(positions) do
		local id1 = octmap.get_node_name(map, p)
		local id2 = octmap.get_node_name(loaded, p)
		if id1 ~= id2 then
			error("loaded map mismatch at " .. core.pos_to_string(p))
		end
	end
end)