local testutil = dofile(core.get_modpath("map_octree") .. "/src/tests/util.lua")

---@diagnostic disable: undefined-field


map_octree.tests.register("OctreeManip: frozen_snapshot prevents refresh", function(ctx)
	assert(ctx and ctx.player, "ctx.player required")

	local base = vector.round(ctx.player:get_pos())
	local center = octchunk.snap_to_center(vector.add(base, {x = 64, y = 0, z = 96}))
	local half = octchunk.SIZE / 2
	local pmin = vector.subtract(center, {x = half, y = half, z = half})
	local pmax = vector.add(center, {x = half - 1, y = half - 1, z = half - 1})

	local node_a = "default:stone"
	local node_b = "default:dirt"
	local cid_a = core.get_content_id(node_a)
	local cid_b = core.get_content_id(node_b)
	assert(type(cid_a) == "number", "missing node: " .. node_a)
	assert(type(cid_b) == "number", "missing node: " .. node_b)

	local p = vector.new(center.x, center.y, center.z)

	testutil.with_voxel_region(pmin, pmax, function(manip, area, data, param2_data)
		local idx = area:index(p.x, p.y, p.z)

		-- Ensure starting map state is node_a
		data[idx] = cid_a
		if param2_data then param2_data[idx] = 0 end
		manip:set_data(data)
		if manip.set_param2_data and param2_data then
			manip:set_param2_data(param2_data)
		end
		manip:write_to_map(false)

		-- Non-frozen: snapshot should update to reflect our committed delta.
		local m = map_octree.new_octree_manip()
		m:read_from_map(center, center)
		assert(m:set_node_at(p.x, p.y, p.z, node_b, 0), "set_node_at failed")
		assert(m:write_to_map(), "write_to_map failed")
		local got1 = select(1, m:get_node_at(p.x, p.y, p.z))
		assert(got1 == node_b, "expected snapshot to refresh after write")

		-- Reset live map back to A for the frozen test
		data[idx] = cid_a
		if param2_data then param2_data[idx] = 0 end
		manip:set_data(data)
		if manip.set_param2_data and param2_data then
			manip:set_param2_data(param2_data)
		end
		manip:write_to_map(false)

		-- Frozen: snapshot should NOT update even though it commits to the live map.
		local mf = map_octree.new_octree_manip({frozen_snapshot = true})
		mf:read_from_map(center, center)
		assert(mf:set_node_at(p.x, p.y, p.z, node_b, 0), "set_node_at failed (frozen)")
		assert(mf:write_to_map(), "write_to_map failed (frozen)")
		local got2 = select(1, mf:get_node_at(p.x, p.y, p.z))
		assert(got2 == node_a, "expected frozen snapshot to not refresh")
	end)
end)