local testutil = dofile(core.get_modpath("map_octree") .. "/src/tests/util.lua")

map_octree.tests.register("load_map registry + subdir", function(ctx)
    assert(ctx and ctx.player, "ctx.player required")

    local oc = octchunk
    local base = testutil.get_test_region(ctx.player)
    local center = vector.add(oc.snap_to_center(base), {x = 0, y = 0, z = 9600})
    local half = oc.SIZE / 2
    local pmin = vector.subtract(center, {x = half, y = half, z = half})
    local pmax = vector.add(pmin, {x = oc.SIZE - 1, y = oc.SIZE - 1, z = oc.SIZE - 1})

    core.load_area(pmin, pmax)

    local stamp = tostring(os.time())
    local name_a = "load_map_a_" .. stamp
    local name_b = "load_map_b_" .. stamp

    local map_a_save, err_a = map_octree.save_to_file(pmin, pmax, {
        file_name = name_a,
        subdir = "tests_a",
        force_batches = true,
        max_voxelmanip_volume = (oc.SIZE + 1) ^ 3,
    })
    assert(map_a_save, err_a or "save_to_file failed")

    local map_b_save, err_b = map_octree.save_to_file(pmin, pmax, {
        file_name = name_b,
        subdir = "tests_b",
        force_batches = true,
        max_voxelmanip_volume = (oc.SIZE + 1) ^ 3,
    })
    assert(map_b_save, err_b or "save_to_file failed")

    map_octree.current_map = nil
    local map_default = map_octree.load_map(name_a, {subdir = "tests_a"})
    assert(map_default, "expected map_default")
    assert(map_octree.current_map == map_default, "current_map should update on default load")
    assert(map_octree.get_loaded_map("tests_a/" .. name_a) == map_default, "default key should be registered")

    local current = map_octree.current_map

    local map_a = map_octree.load_map(name_a, {subdir = "tests_a", key = "zone_a", set_current = false})
    assert(map_a, "expected map_a")

    local map_b = map_octree.load_map(name_b, {subdir = "tests_b", key = "zone_b", set_current = false})
    assert(map_b, "expected map_b")

    assert(map_octree.current_map == current, "current_map should not change when set_current=false")
    assert(map_octree.get_loaded_map("zone_a") == map_a, "zone_a should be registered")
    assert(map_octree.get_loaded_map("zone_b") == map_b, "zone_b should be registered")

    local keys = map_octree.list_loaded_maps()
    local found_a = false
    local found_b = false
    for _, key in ipairs(keys) do
        if key == "zone_a" then
            found_a = true
        elseif key == "zone_b" then
            found_b = true
        end
    end
    assert(found_a and found_b, "expected zone_a and zone_b in list_loaded_maps")

    local ok, err = map_octree.unload_map("zone_a")
    assert(ok, err or "unload_map should succeed")
    assert(map_octree.get_loaded_map("zone_a") == nil, "zone_a should be removed")

    ok, err = map_octree.unload_map("zone_b")
    assert(ok, err or "unload_map should succeed")
    assert(map_octree.get_loaded_map("zone_b") == nil, "zone_b should be removed")

    map_default:enable_tracking()
    assert(map_default:get_tracking_status(), "tracking should be enabled before unload")
    ok, err = map_octree.unload_map("tests_a/" .. name_a)
    assert(ok, err or "unload_map should succeed for default key")
    assert(map_default:get_tracking_status() == nil, "tracking should be disabled on unload")

    local dir_a = map_octree.get_storage_dir("tests_a")
    local dir_b = map_octree.get_storage_dir("tests_b")
    os.remove(dir_a .. "/" .. name_a .. ".bin")
    os.remove(dir_b .. "/" .. name_b .. ".bin")
end)
