map_octree.tests.register("octree correctness: 1 chunk vs VoxelManip", function(ctx)
	assert(ctx and ctx.player, "ctx.player required")
	local player = ctx.player

	local pos = vector.round(player:get_pos())
	local center = octchunk.snap_to_center(pos)

	local map = octmap.new(center, center, {
		-- force batching with tiny limits to ensure batching path is exercised
		max_voxelmanip_volume = (octchunk.SIZE + 1) ^ 3 * 2,
		force_batches = true,
	})

	local half = octchunk.SIZE / 2
	local min_truth = vector.subtract(center, {x = half, y = half, z = half})
	local max_truth = vector.add(center, {x = half - 1, y = half - 1, z = half - 1})

	core.load_area(min_truth, max_truth)
	local manip = core.get_voxel_manip()
	local e1, e2 = manip:read_from_map(min_truth, max_truth)
	local area = VoxelArea(e1, e2)
	local data = {}
	manip:get_data(data)

	for x = min_truth.x, max_truth.x do
		for y = min_truth.y, max_truth.y do
			for z = min_truth.z, max_truth.z do
				local idx = area:index(x, y, z)
				local expected_name = core.get_name_from_content_id(data[idx])
				local got_name = octmap.get_node_name(map, {x = x, y = y, z = z})
				if not got_name then
					error(string.format("missing node at %d,%d,%d", x, y, z))
				end
				if expected_name ~= got_name then
					error(string.format(
						"mismatch at %d,%d,%d: expected '%s', got '%s'",
						x, y, z, expected_name, got_name
					))
				end
			end
		end
	end
end)