local testutil = dofile(core.get_modpath("map_octree") .. "/src/tests/util.lua")

map_octree.tests.register("OctreeManip:for_each_node returns expected nodes", function(ctx)
	assert(ctx and ctx.player, "ctx.player required")
	local oc = octchunk
	local pos0 = testutil.get_test_region(ctx.player)
	local center = oc.snap_to_center(pos0)
	local pmin = vector.subtract(center, {x = 1, y = 1, z = 1})
	local pmax = vector.add(center, {x = 1, y = 1, z = 1})

	testutil.with_voxel_region(pmin, pmax, function(manip, area, data, param2_data)
		local cid_a = core.get_content_id("default:stone")
		local cid_b = core.get_content_id("default:dirt")
		testutil.fill_region(area, data, pmin, pmax, function(x, y, z)
			if (x + y + z) % 2 == 0 then
				return cid_a
			end
			return cid_b
		end)

		for x = pmin.x, pmax.x do
			for y = pmin.y, pmax.y do
				for z = pmin.z, pmax.z do
					local idx = area:index(x, y, z)
					if x == pmin.x and y == pmin.y and z == pmin.z then
						param2_data[idx] = 7
					else
						param2_data[idx] = 0
					end
				end
			end
		end

		manip:set_data(data)
		manip:set_param2_data(param2_data)
		manip:write_to_map(false)

		local m = map_octree.new_octree_manip()
		m:read_from_map(pmin, pmax)

		local expected = (pmax.x - pmin.x + 1) * (pmax.y - pmin.y + 1) * (pmax.z - pmin.z + 1)
		local seen = 0
		local special = 0
		m:for_each_node(pmin, pmax, function(x, y, z, name, p2)
			seen = seen + 1
			local expected_name = ((x + y + z) % 2 == 0) and "default:stone" or "default:dirt"
			assert(name == expected_name, "unexpected node at " .. x .. "," .. y .. "," .. z)
			if x == pmin.x and y == pmin.y and z == pmin.z then
				special = special + 1
				assert(p2 == 7, "expected param2=7 at min corner")
			else
				assert(p2 == 0, "expected param2=0")
			end
		end)

		assert(seen == expected, string.format("expected %d nodes, got %d", expected, seen))
		assert(special == 1, string.format("expected 1 special node, got %d", special))
	end)
end)
