local testutil = dofile(core.get_modpath("map_octree") .. "/src/tests/util.lua")

map_octree.tests.register("octmap: LRU order touch", function(ctx)
	assert(ctx and ctx.player, "ctx.player required")
	local pos = vector.round(ctx.player:get_pos())
	local center1 = octchunk.snap_to_center(pos)
	local center2 = vector.add(center1, {x = octchunk.SIZE, y = 0, z = 0})
	local half = octchunk.SIZE / 2
	local pmin = vector.subtract(center1, {x = half, y = half, z = half})
	local pmax = vector.add(center2, {x = half - 1, y = half - 1, z = half - 1})

	testutil.with_voxel_region(pmin, pmax, function(manip, area, data)
		local c_stone = core.get_content_id("default:stone")
		local c_dirt = core.get_content_id("default:dirt")
		assert(type(c_stone) == "number" and type(c_dirt) == "number", "missing test nodes")

		for x = pmin.x, pmax.x do
			for y = pmin.y, pmax.y do
				for z = pmin.z, pmax.z do
					data[area:index(x, y, z)] = c_stone
				end
			end
		end

		data[area:index(center1.x, center1.y, center1.z)] = c_dirt
		data[area:index(center2.x, center2.y, center2.z)] = c_dirt
		manip:set_data(data)
		manip:write_to_map(false)

		local map = octmap.new(center1, center2, {
			store_chunk_blobs = true,
			max_voxelmanip_volume = (octchunk.SIZE + 1) ^ 3 * 4,
			force_batches = true,
		})

		local function pos_to_key(p)
		local snapped = octchunk.snap_to_center(p)
		local gx = 1 + math.floor((snapped.x - map.minp.x) / octchunk.SIZE)
		local gy = 1 + math.floor((snapped.y - map.minp.y) / octchunk.SIZE)
		local gz = 1 + math.floor((snapped.z - map.minp.z) / octchunk.SIZE)
		return ((gx - 1) * map.trees.size.y + (gy - 1)) * map.trees.size.z + gz
		end

		local key1 = pos_to_key(center1)
		local key2 = pos_to_key(center2)

		octmap.get_node_name(map, center1)
		octmap.get_node_name(map, center2)

		local lru = map._tree_cache_lru
		assert(lru and lru.head == key1 and lru.tail == key2, "LRU order did not match initial access order")

		octmap.get_node_name(map, center1)
		assert(lru.head == key2 and lru.tail == key1, "LRU order did not update on touch")
	end)
end)