# map_octree

> **Beta version, expect issues and breaking changes (even though there's a lot of automatic testing)**   
>   Development assisted by AI (code and documentation).


A library for saving large world regions as compressed octree snapshots. Useful for schematics, backups, and fast node queries on huge areas without exhausting server memory.

## Documentation

- [DOCS.md](DOCS.md) — Full Lua API reference for mod developers.
- [ARCHITECTURE.md](ARCHITECTURE.md) — Internal design and data flow.

---

## Quick Start (for server admins)

All commands require `server` priv.

### 1. Save a region

Use `/octree_pos1` and `/octree_pos2` to mark corners (or //pos1 and //pos2 with WorldEdit), then:

```
/octree_save <name>
```

Or save around yourself with a radius:

```
/octree_save <name> <radius> [<height>]
```

Snapshots are stored at `worldpath/map_octree/<name>.bin`.

### 2. Place

```
/octree_place <name> [x,y,z]
```

If no position is given, it places at the original capture location.

### 3. Optimize for your server (recommended)

Go to a **representative area** of your world (e.g., a complex build, a dense city center, or a typical biome) and run:

```
/octree_autotune
```

This benchmarks your server and applies the optimal batch settings automatically.

### Other useful commands

| Command | Description |
|---------|-------------|
| `/octree_maps` | List saved snapshots |
| `/octree_info` | Info about loaded snapshot |

Use `/help` in-game for advanced options.

---

## Settings

Configure in `minetest.conf` or via the Settings menu.

| Setting | Default | Description |
|---------|---------|-------------|
| `map_octree_max_total_ram_budget_mb` | 1000 | Max RAM (MB) for snapshot operations. Lower this on low-memory servers (e.g., 256–512). |
| `map_octree_reduce_unload_timeout` | false | Force aggressive mapblock unloading during saves. Enable only on very low-RAM servers where you experience crashes as it is annoying for other players. |

**Note on RAM budget:** This value is only an estimate. Lua memory usage and GC behavior make it impossible to enforce an exact cap. For safety, set the budget to roughly **half** of the maximum memory you are willing to allocate to map_octree. On large-scale operations or on servers that are already memory-heavy, the cap may be exceeded anyway (other mods, many active mapblocks, players online, etc.). Treat it as a starting point and **tune it for your setup**.
