--- Mod storage helpers for map_octree_lib.

local LAST_TIMEOUT_KEY = "last_timeout"
local storage = core.get_mod_storage()



function map_octree.storage_get_string(key)
    return storage:get_string(key)
end



function map_octree.storage_set_string(key, value)
    storage:set_string(key, value or "")
end



function map_octree.storage_get_last_timeout()
    return map_octree.storage_get_string(LAST_TIMEOUT_KEY)
end



function map_octree.storage_set_last_timeout(value)
    map_octree.storage_set_string(LAST_TIMEOUT_KEY, tostring(value or ""))
end



function map_octree.storage_clear_last_timeout()
    map_octree.storage_set_string(LAST_TIMEOUT_KEY, "")
end



function map_octree.restore_unload_timeout_from_storage()
    local saved = map_octree.storage_get_last_timeout()
    if saved == "" then
        return
    end
    core.settings:set("server_unload_unused_data_timeout", saved)
    local ok = core.settings:write()
    if ok == false then
        core.log("warning", "[map_octree] Failed to write settings after restoring server_unload_unused_data_timeout")
    end
    core.log("action", "[map_octree] Restored server_unload_unused_data_timeout=" .. saved .. " (storage)")
    map_octree.storage_clear_last_timeout()
end


map_octree.restore_unload_timeout_from_storage()
core.register_on_shutdown(map_octree.restore_unload_timeout_from_storage)
