local tutil = dofile(core.get_modpath("map_octree") .. "/src/tests/util.lua")

map_octree.tests.register("generated pattern: forces fast paths", function(ctx)
	assert(ctx and ctx.player, "ctx.player required")
	local center = tutil.get_test_region(ctx.player)

	local c_air = core.get_content_id("air")
	local c_stone = core.get_content_id("default:stone")
	local c_dirt = core.get_content_id("default:dirt")

	local S = octchunk.SIZE
	local half = S / 2
	-- build a SIZE^3 region with:
	-- - most of it uniform stone (merge)
	-- - a small subcube of dirt to break uniformity
	-- - a small 2x2x2 air pocket (size==2 base-case exercised deep)
	local pmin = vector.subtract(center, {x = half, y = half, z = half})
	local pmax = vector.add(center, {x = half - 1, y = half - 1, z = half - 1})

	tutil.with_voxel_region(pmin, pmax, function(manip, area, data)
		-- write pattern
		tutil.fill_region(area, data, pmin, pmax, function()
			return c_stone
		end)

		local dirt_off = math.min(half / 2, 4)
		local dirt_min = {x = center.x - dirt_off, y = center.y - dirt_off, z = center.z - dirt_off}
		local dirt_max = {x = center.x + dirt_off - 1, y = center.y + dirt_off - 1, z = center.z + dirt_off - 1}
		tutil.fill_region(area, data, dirt_min, dirt_max, function()
			return c_dirt
		end)

		local air_off = math.min(half - 3, 4)
		local air_min = {x = center.x + air_off, y = center.y + air_off, z = center.z + air_off}
		local air_max = {x = center.x + air_off + 1, y = center.y + air_off + 1, z = center.z + air_off + 1}
		tutil.fill_region(area, data, air_min, air_max, function()
			return c_air
		end)

		manip:set_data(data)
		manip:write_to_map(false)

		-- Now read with octmap and validate every node against the generated pattern
		local map = octmap.new(center, center, {
			max_voxelmanip_volume = (octchunk.SIZE + 1) ^ 3 + 1024,
			force_batches = true,
		})

		for x = pmin.x, pmax.x do
			for y = pmin.y, pmax.y do
				for z = pmin.z, pmax.z do
					local idx = area:index(x, y, z)
					local expected_name = core.get_name_from_content_id(data[idx])
					local got_name = octmap.get_node_name(map, {x = x, y = y, z = z})
					if expected_name ~= got_name then
						error(string.format(
							"mismatch at %d,%d,%d: expected '%s', got '%s'",
							x, y, z, expected_name, tostring(got_name)
						))
					end
				end
			end
		end
	end)
end)