map_octree.tests.register("octree correctness: multibatch 2x2x1 vs VoxelManip", function(ctx)
	assert(ctx and ctx.player, "ctx.player required")
	local pos = vector.round(ctx.player:get_pos())
	local base_center = octchunk.snap_to_center(pos)

	local S = octchunk.SIZE
	local half = S / 2
	local max_center = vector.add(base_center, {x = S, y = S, z = 0})
	local limit_one_tree = (S + 1) ^ 3 + 1024

	local map = octmap.new(base_center, max_center, {
		max_voxelmanip_volume = limit_one_tree,
		force_batches = true,
	})

	local min_truth = vector.subtract(base_center, {x = half, y = half, z = half})
	local max_truth = vector.add(max_center, {x = half - 1, y = half - 1, z = half - 1})

	core.load_area(min_truth, max_truth)
	local manip = core.get_voxel_manip()
	local e1, e2 = manip:read_from_map(min_truth, max_truth)
	local area = VoxelArea(e1, e2)
	local data = {}
	manip:get_data(data)

	for x = min_truth.x, max_truth.x do
		for y = min_truth.y, max_truth.y do
			for z = min_truth.z, max_truth.z do
				local idx = area:index(x, y, z)
				local expected_name = core.get_name_from_content_id(data[idx])
				local got_name = octmap.get_node_name(map, {x = x, y = y, z = z})
				if expected_name ~= got_name then
					error(string.format(
						"mismatch at %d,%d,%d: expected '%s', got '%s'",
						x, y, z, expected_name, tostring(got_name)
					))
				end
			end
		end
	end
end)